export interface CompetencyModel {
  competency: Competency[]
  idp: Idp
  pms: Pms
  evaluationRoundId: string
  tdesc: string
  edesc: string
  apsassessy: ApsEmp
  apsapprove1: ApsEmp
  apsapprove2: ApsEmp
  apsapprove3: ApsEmp
  apsapprove4: ApsEmp
  apsapprove5: ApsEmp
  currentStep: string
  statusType: string
  stepReturn: string
  commentAll: CommentAll[]
}
export interface ApsEmp {
  employeeId: string
  status: string
  thFullName: string
  enFullName: string
}
export interface CommentAll {
  commentDate: string
  companyId: string
  currentStep: string
  statusType: string
  comment: string
  createdBy: string
  thFullName: string
  engFullName: string
}

export interface Competency {
  active: boolean
  apsapprove1: Apsapprove1
  apsapprove2: Apsapprove2
  apsapprove3: Apsapprove3
  apsapprove4: Apsapprove4
  apsapprove5: Apsapprove5
  apsassessy: Apsassessy
  checkStep: string
  companyId: string
  comType: string
  currentStep: string
  lastStep: string
  masfromEvaluationAssessment1List: masfromEvaluationAssessment1List[]
  masfromEvaluationRound: MasfromEvaluationRound
  masfromStatusType: MasfromStatusType
  personalLevel: PersonalLevel2
}

export interface Apsapprove1 {
  bossId: string
  bu1: Bu1
  bu2: Bu2
  bu3: Bu3
  bu4: Bu4
  bu5: Bu5
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: Job
  lname: string
  pl: Pl
  position: Position
  prefix: Prefix
  resignDate: string
  startDate: string
  status: Status
  thFullName: string
  time0: Time0
}

export interface Bu1 {
  bu1id: string
  companyId: string
  edesc: string
  tdesc: string
}

export interface Bu2 {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu3 {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu4 {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu5 {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Job {
  edesc: string
  jobCodeId: string
  tdesc: string
}

export interface Pl {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface Position {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
}

export interface Prefix {
  edesc: string
  prefixId: string
  tdesc: string
}

export interface Status {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
}

export interface Time0 {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
}

export interface Apsapprove2 {
  bossId: string
  bu1: Bu12
  bu2: Bu22
  bu3: Bu32
  bu4: Bu42
  bu5: Bu52
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: Job2
  lname: string
  pl: Pl2
  position: Position2
  prefix: Prefix2
  resignDate: string
  startDate: string
  status: Status2
  thFullName: string
  time0: Time02
}

export interface Bu12 {
  bu1id: string
  companyId: string
  edesc: string
  tdesc: string
}

export interface Bu22 {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu32 {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu42 {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu52 {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Job2 {
  edesc: string
  jobCodeId: string
  tdesc: string
}

export interface Pl2 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface Position2 {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
}

export interface Prefix2 {
  edesc: string
  prefixId: string
  tdesc: string
}

export interface Status2 {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
}

export interface Time02 {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
}

export interface Apsapprove3 {
  bossId: string
  bu1: Bu13
  bu2: Bu23
  bu3: Bu33
  bu4: Bu43
  bu5: Bu53
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: Job3
  lname: string
  pl: Pl3
  position: Position3
  prefix: Prefix3
  resignDate: string
  startDate: string
  status: Status3
  thFullName: string
  time0: Time03
}

export interface Bu13 {
  bu1id: string
  companyId: string
  edesc: string
  tdesc: string
}

export interface Bu23 {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu33 {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu43 {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu53 {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Job3 {
  edesc: string
  jobCodeId: string
  tdesc: string
}

export interface Pl3 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface Position3 {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
}

export interface Prefix3 {
  edesc: string
  prefixId: string
  tdesc: string
}

export interface Status3 {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
}

export interface Time03 {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
}

export interface Apsapprove4 {
  bossId: string
  bu1: Bu14
  bu2: Bu24
  bu3: Bu34
  bu4: Bu44
  bu5: Bu54
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: Job4
  lname: string
  pl: Pl4
  position: Position4
  prefix: Prefix4
  resignDate: string
  startDate: string
  status: Status4
  thFullName: string
  time0: Time04
}

export interface Bu14 {
  bu1id: string
  companyId: string
  edesc: string
  tdesc: string
}

export interface Bu24 {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu34 {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu44 {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu54 {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Job4 {
  edesc: string
  jobCodeId: string
  tdesc: string
}

export interface Pl4 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface Position4 {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
}

export interface Prefix4 {
  edesc: string
  prefixId: string
  tdesc: string
}

export interface Status4 {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
}

export interface Time04 {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
}

export interface Apsapprove5 {
  bossId: string
  bu1: Bu15
  bu2: Bu25
  bu3: Bu35
  bu4: Bu45
  bu5: Bu55
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: Job5
  lname: string
  pl: Pl5
  position: Position5
  prefix: Prefix5
  resignDate: string
  startDate: string
  status: Status5
  thFullName: string
  time0: Time05
}

export interface Bu15 {
  bu1id: string
  companyId: string
  edesc: string
  tdesc: string
}

export interface Bu25 {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu35 {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu45 {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu55 {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Job5 {
  edesc: string
  jobCodeId: string
  tdesc: string
}

export interface Pl5 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface Position5 {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
}

export interface Prefix5 {
  edesc: string
  prefixId: string
  tdesc: string
}

export interface Status5 {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
}

export interface Time05 {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
}

export interface Apsassessy {
  bossId: string
  bu1: Bu16
  bu2: Bu26
  bu3: Bu36
  bu4: Bu46
  bu5: Bu56
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: Job6
  lname: string
  pl: Pl6
  position: Position6
  prefix: Prefix6
  resignDate: string
  startDate: string
  status: Status6
  thFullName: string
  time0: Time06
}

export interface Bu16 {
  bu1id: string
  companyId: string
  edesc: string
  tdesc: string
}

export interface Bu26 {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu36 {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu46 {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu56 {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Job6 {
  edesc: string
  jobCodeId: string
  tdesc: string
}

export interface Pl6 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface Position6 {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
}

export interface Prefix6 {
  edesc: string
  prefixId: string
  tdesc: string
}

export interface Status6 {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
}

export interface Time06 {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
}

export interface masfromEvaluationAssessment1List {
  apsapprove1Comment: string
  apsapprove1Date: string
  apsapprove1Status: string
  apsapprove2Comment: string
  apsapprove2Date: string
  apsapprove2Status: string
  apsapprove3Comment: string
  apsapprove3Date: string
  apsapprove3Status: string
  apsapprove4Comment: string
  apsapprove4Date: string
  apsapprove4Status: string
  apsapprove5Comment: string
  apsapprove5Date: string
  apsapprove5Status: string
  apsassessyComment: string
  apsassessyDate: string
  apsassessyStatus: string
  averageScoreBoss: number
  averageScore: number
  companyId: string
  competencyType: CompetencyType
  evaluationResults: string
  lineNo: number
  weightScore1Boss: number
  weightScore2Boss: number
  weightScore3Boss: number
  weightScore4Boss: number
  weightScore5Boss: number
  weightScore6Boss: number
  weightScore7Boss: number
  weightScore1: number
  weightScore2: number
  weightScore3: number
  weightScore4: number
  weightScore5: number
  weightScore6: number
  weightScore7: number
  plId: string
  sumEvaluationResults: string
  weightedTotalBoss: number
  weightedTotal: number
  masfromEvaluationAssessment2List: MasfromEvaluationAssessment2List[]
  scoreGab: string
  scoreGabBoss: string
}

export interface MasfromEvaluationAssessment2List {
  masfromEvaluationAssessment1: string
  runNo: number
  companyId: string
  scoreTopicExpectation: number
  groupAssessment1: GroupAssessment1
  competencyFiles: any
}

export interface GroupAssessment1 {
  personalLevelModel: PersonalLevelModel
  competencyIndicatorsCourses1Mini: CompetencyIndicatorsCourses1Mini
  companyId: string
  groupAssessmentMini: GroupAssessmentMini
}

export interface GroupAssessmentMini {
  personalLevel: PersonalLevel2
  competencyIndicatorsCourses1Mini: CompetencyIndicatorsCourses1Mini2
  companyId: string
  edesc: string
  tdesc: string
}

export interface CompetencyIndicatorsCourses1Mini2 {
  competencyIndicatorsCourses0: CompetencyIndicatorsCourses03
  lineNo: number
  companyId: string
  competencyCourseId: string
  competencyCourse: CompetencyCourse2[]
  behavioralIndicatorsList: BehavioralIndicatorsList2[]
}

export interface CompetencyIndicatorsCourses03 {
  competencyTopic: CompetencyTopic3
  companyId: string
  edesc: string
  tdesc: string
  indicatorsCourseDetailTh: string
  indicatorsCourseDetailEn: string
  expectation: string
}

export interface BehavioralIndicatorsList2 {
  competencyIndicators1: CompetencyIndicators12
  runNo: number
  companyId: string
  assessmentId: string
  behavioralIndicators: string
  competencyAssessment: CompetencyAssessment2[]
  competencyBehavioral: CompetencyBehavioral2
}

export interface CompetencyBehavioral2 {
  scoreTopicExpectation: number
  companyId: string
}


export interface CompetencyAssessment2 {
  assessmentId: string
  companyId: string
  edesc: string
  tdesc: string
  shortName: string
}

export interface CompetencyTopic4 {
  competencyTopicId: string
  competencyType: CompetencyType5
  companyId: string
  edesc: string
  tdesc: string
  competencyDetail: string
  competencyFiles: string
  lineNo: number
  expectationLevel: string
}

export interface CompetencyIndicators12 {
  competencyIndicatorsCourses0: CompetencyIndicatorsCourses04
  lineNo: number
  companyId: string
  competencyCourseId: string
}

export interface CompetencyIndicatorsCourses04 {
  competencyTopic: CompetencyTopic4
  companyId: string
  edesc: string
  tdesc: string
  indicatorsCourseDetailTh: string
  indicatorsCourseDetailEn: string
}


export interface CompetencyCourse2 {
  competencyCourseId: string
  companyId: string
  edesc: string
  tdesc: string
  courseDetail: string
  courseTopic: string
  courseLinkMylearn: string
}


export interface CompetencyTopic3 {
  competencyTopicId: string
  competencyType: CompetencyType4
  companyId: string
  edesc: string
  tdesc: string
  competencyDetail: string
  competencyFiles: string
  lineNo: number
  expectationLevel: string
}

export interface CompetencyType4 {
  competencyTypeId: string
  companyId: string
  edesc: string
  tdesc: string
  shortName: string
  expectationLevel: string
}

export interface BehavioralIndicatorsList {
  competencyIndicators1: CompetencyIndicators1
  runNo: number
  companyId: string
  assessmentId: string
  behavioralIndicators: string
  competencyAssessment: CompetencyAssessment[]
  competencyBehavioral: CompetencyBehavioral
}

export interface CompetencyBehavioral {
  scoreTopicExpectationBoss: number
  scoreTopicExpectation: number
  companyId: string
}


export interface CompetencyIndicatorsCourses1Mini {
  competencyIndicatorsCourses0: CompetencyIndicatorsCourses0
  lineNo: number
  companyId: string
  competencyCourseId: string
  competencyCourse: CompetencyCourse[]
  behavioralIndicatorsList: BehavioralIndicatorsList[]
}

export interface CompetencyType {
  companyId: string
  competencyTypeId: string
  edesc: string
  expectationLevel: string
  shortName: string
  tdesc: string
  weight: number
}

export interface MasfromEvaluationRound {
  active: number
  apsPeriodEnd: string
  apsPeriodStart: string
  apsyear: string
  checkForm: number
  companyId: string
  edesc: string
  evaluationRoundId: string
  jlId: string
  personalLevel: PersonalLevel[]
  statusCode: StatusCode
  statusFrom: StatusFrom
  tdesc: string
}

export interface PersonalLevel {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface StatusCode {
  code: string
  edesc: string
  tdesc: string
}

export interface StatusFrom {
  code: string
  edesc: string
  tdesc: string
}

export interface MasfromStatusType {
  code: string
  edesc: string
  tdesc: string
}

export interface PersonalLevel2 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface Idp {
  active: boolean
  apsapprove1: Apsapprove12
  apsapprove2: Apsapprove22
  apsapprove3: Apsapprove32
  apsapprove4: Apsapprove42
  apsapprove5: Apsapprove52
  apsassessy: Apsassessy2
  boss: Boss
  checkStep: string
  companyId: string
  competencyIndicatorsCourses1: CompetencyIndicatorsCourses1[]
  countFormStep: string
  currentStep: string
  lastStep: string
  masfromEvaluationIdp: MasfromEvaluationIdp
  masfromEvaluationRound: MasfromEvaluationRound3
  masfromStatusType: MasfromStatusType3
  personalLevel: PersonalLevel5
}

export interface Apsapprove12 {
  bossId: string
  bu1: Bu17
  bu2: Bu27
  bu3: Bu37
  bu4: Bu47
  bu5: Bu57
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: Job7
  lname: string
  pl: Pl7
  position: Position7
  prefix: Prefix7
  resignDate: string
  startDate: string
  status: Status7
  thFullName: string
  time0: Time07
}

export interface Bu17 {
  bu1id: string
  companyId: string
  edesc: string
  tdesc: string
}

export interface Bu27 {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu37 {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu47 {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu57 {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Job7 {
  edesc: string
  jobCodeId: string
  tdesc: string
}

export interface Pl7 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface Position7 {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
}

export interface Prefix7 {
  edesc: string
  prefixId: string
  tdesc: string
}

export interface Status7 {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
}

export interface Time07 {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
}

export interface Apsapprove22 {
  bossId: string
  bu1: Bu18
  bu2: Bu28
  bu3: Bu38
  bu4: Bu48
  bu5: Bu58
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: Job8
  lname: string
  pl: Pl8
  position: Position8
  prefix: Prefix8
  resignDate: string
  startDate: string
  status: Status8
  thFullName: string
  time0: Time08
}

export interface Bu18 {
  bu1id: string
  companyId: string
  edesc: string
  tdesc: string
}

export interface Bu28 {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu38 {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu48 {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu58 {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Job8 {
  edesc: string
  jobCodeId: string
  tdesc: string
}

export interface Pl8 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface Position8 {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
}

export interface Prefix8 {
  edesc: string
  prefixId: string
  tdesc: string
}

export interface Status8 {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
}

export interface Time08 {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
}

export interface Apsapprove32 {
  bossId: string
  bu1: Bu19
  bu2: Bu29
  bu3: Bu39
  bu4: Bu49
  bu5: Bu59
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: Job9
  lname: string
  pl: Pl9
  position: Position9
  prefix: Prefix9
  resignDate: string
  startDate: string
  status: Status9
  thFullName: string
  time0: Time09
}

export interface Bu19 {
  bu1id: string
  companyId: string
  edesc: string
  tdesc: string
}

export interface Bu29 {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu39 {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu49 {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu59 {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Job9 {
  edesc: string
  jobCodeId: string
  tdesc: string
}

export interface Pl9 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface Position9 {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
}

export interface Prefix9 {
  edesc: string
  prefixId: string
  tdesc: string
}

export interface Status9 {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
}

export interface Time09 {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
}

export interface Apsapprove42 {
  bossId: string
  bu1: Bu110
  bu2: Bu210
  bu3: Bu310
  bu4: Bu410
  bu5: Bu510
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: Job10
  lname: string
  pl: Pl10
  position: Position10
  prefix: Prefix10
  resignDate: string
  startDate: string
  status: Status10
  thFullName: string
  time0: Time010
}

export interface Bu110 {
  bu1id: string
  companyId: string
  edesc: string
  tdesc: string
}

export interface Bu210 {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu310 {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu410 {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu510 {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Job10 {
  edesc: string
  jobCodeId: string
  tdesc: string
}

export interface Pl10 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface Position10 {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
}

export interface Prefix10 {
  edesc: string
  prefixId: string
  tdesc: string
}

export interface Status10 {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
}

export interface Time010 {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
}

export interface Apsapprove52 {
  bossId: string
  bu1: Bu111
  bu2: Bu211
  bu3: Bu311
  bu4: Bu411
  bu5: Bu511
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: Job11
  lname: string
  pl: Pl11
  position: Position11
  prefix: Prefix11
  resignDate: string
  startDate: string
  status: Status11
  thFullName: string
  time0: Time011
}

export interface Bu111 {
  bu1id: string
  companyId: string
  edesc: string
  tdesc: string
}

export interface Bu211 {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu311 {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu411 {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu511 {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Job11 {
  edesc: string
  jobCodeId: string
  tdesc: string
}

export interface Pl11 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface Position11 {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
}

export interface Prefix11 {
  edesc: string
  prefixId: string
  tdesc: string
}

export interface Status11 {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
}

export interface Time011 {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
}

export interface Apsassessy2 {
  bossId: string
  bu1: Bu112
  bu2: Bu212
  bu3: Bu312
  bu4: Bu412
  bu5: Bu512
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: Job12
  lname: string
  pl: Pl12
  position: Position12
  prefix: Prefix12
  resignDate: string
  startDate: string
  status: Status12
  thFullName: string
  time0: Time012
}

export interface Bu112 {
  bu1id: string
  companyId: string
  edesc: string
  tdesc: string
}

export interface Bu212 {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu312 {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu412 {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu512 {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Job12 {
  edesc: string
  jobCodeId: string
  tdesc: string
}

export interface Pl12 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface Position12 {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
}

export interface Prefix12 {
  edesc: string
  prefixId: string
  tdesc: string
}

export interface Status12 {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
}

export interface Time012 {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
}

export interface Boss {
  bossId: string
  bu1: Bu113
  bu2: Bu213
  bu3: Bu313
  bu4: Bu413
  bu5: Bu513
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: Job13
  lname: string
  pl: Pl13
  position: Position13
  prefix: Prefix13
  resignDate: string
  startDate: string
  status: Status13
  thFullName: string
  time0: Time013
}

export interface Bu113 {
  bu1id: string
  companyId: string
  edesc: string
  tdesc: string
}

export interface Bu213 {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu313 {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu413 {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu513 {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Job13 {
  edesc: string
  jobCodeId: string
  tdesc: string
}

export interface Pl13 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface Position13 {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
}

export interface Prefix13 {
  edesc: string
  prefixId: string
  tdesc: string
}

export interface Status13 {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
}

export interface Time013 {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
}

export interface CompetencyIndicatorsCourses1 {
  behavioralIndicators: BehavioralIndicator[]
  competencyCourse: CompetencyCourse[]
  competencyCourseId: string
  idpDevelopmentPlan: IdpDevelopmentPlan | null
  indicatorsCourses0: IndicatorsCourses0,
  startDate: string
  endDate: string
}

export interface BehavioralIndicator {
  assessmentId: string
  behavioralIndicators: string
  companyId: string
  competencyAssessment: CompetencyAssessment[]
  competencyIndicators1: CompetencyIndicators1
  runNo: number
}

export interface CompetencyAssessment {
  assessmentId: string
  companyId: string
  edesc: string
  shortName: string
  tdesc: string
}

export interface CompetencyIndicators1 {
  companyId: string
  competencyCourseId: string
  competencyIndicatorsCourses0: CompetencyIndicatorsCourses0
  lineNo: number
}

export interface CompetencyIndicatorsCourses0 {
  companyId: string
  competencyTopic: CompetencyTopic
  edesc: string
  indicatorsCourseDetailEn: string
  indicatorsCourseDetailTh: string
  tdesc: string
}

export interface CompetencyTopic {
  companyId: string
  competencyDetail: string
  competencyFiles: string
  competencyTopicId: string
  competencyType: CompetencyType2
  edesc: string
  expectationLevel: string
  lineNo: number
  tdesc: string
}

export interface CompetencyType2 {
  companyId: string
  competencyTypeId: string
  edesc: string
  expectationLevel: string
  shortName: string
  tdesc: string
  weight: number
}

export interface CompetencyCourse {
  companyId: string
  competencyCourseId: string
  edesc: string
  tdesc: string
}

export interface IdpDevelopmentPlan {
  coachMentor: boolean
  companyId: string
  evaluationId: string
  ojtJobAssignment: boolean
  planId: string
  planName: string
  training: boolean
}

export interface IndicatorsCourses0 {
  companyId: string
  competencyTopic: CompetencyTopic2
  edesc: string
  indicatorsCourseDetailEn: string
  indicatorsCourseDetailTh: string
  tdesc: string
}

export interface CompetencyTopic2 {
  companyId: string
  competencyDetail: string
  competencyFiles: string
  competencyTopicId: string
  competencyType: CompetencyType3
  edesc: string
  expectationLevel: string
  lineNo: number
  tdesc: string
}

export interface CompetencyType3 {
  companyId: string
  competencyTypeId: string
  edesc: string
  expectationLevel: string
  shortName: string
  tdesc: string
  weight: number
}

export interface MasfromEvaluationIdp {
  apsapprove1Comment: string
  apsapprove1Date: string
  apsapprove1Status: string
  apsapprove2Comment: string
  apsapprove2Date: string
  apsapprove2Status: string
  apsapprove3Comment: string
  apsapprove3Date: string
  apsapprove3Status: string
  apsapprove4Comment: string
  apsapprove4Date: string
  apsapprove4Status: string
  apsapprove5Comment: string
  apsapprove5Date: string
  apsapprove5Status: string
  apsassessyComment: string
  apsassessyDate: string
  apsassessyStatus: string
  companyId: string
  idpStatus: string
  masfromEvaluationAssessment: MasfromEvaluationAssessment
  plId: string
}

export interface MasfromEvaluationAssessment {
  active: boolean
  apsapprove1: Apsapprove13
  apsapprove2: Apsapprove23
  apsapprove3: Apsapprove33
  apsapprove4: Apsapprove43
  apsapprove5: Apsapprove53
  apsassessy: Apsassessy3
  companyId: string
  masfromEvaluationAssessment1: MasfromEvaluationAssessment1[]
  masfromEvaluationRound: MasfromEvaluationRound2
  personalLevel: PersonalLevel4
  statusCheckDate: boolean
}

export interface Apsapprove13 {
  bossId: string
  bu1: Bu114
  bu2: Bu214
  bu3: Bu314
  bu4: Bu414
  bu5: Bu514
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: Job14
  lname: string
  pl: Pl14
  position: Position14
  prefix: Prefix14
  resignDate: string
  startDate: string
  status: Status14
  thFullName: string
  time0: Time014
}

export interface Bu114 {
  bu1id: string
  companyId: string
  edesc: string
  tdesc: string
}

export interface Bu214 {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu314 {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu414 {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu514 {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Job14 {
  edesc: string
  jobCodeId: string
  tdesc: string
}

export interface Pl14 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface Position14 {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
}

export interface Prefix14 {
  edesc: string
  prefixId: string
  tdesc: string
}

export interface Status14 {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
}

export interface Time014 {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
}

export interface Apsapprove23 {
  bossId: string
  bu1: Bu115
  bu2: Bu215
  bu3: Bu315
  bu4: Bu415
  bu5: Bu515
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: Job15
  lname: string
  pl: Pl15
  position: Position15
  prefix: Prefix15
  resignDate: string
  startDate: string
  status: Status15
  thFullName: string
  time0: Time015
}

export interface Bu115 {
  bu1id: string
  companyId: string
  edesc: string
  tdesc: string
}

export interface Bu215 {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu315 {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu415 {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu515 {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Job15 {
  edesc: string
  jobCodeId: string
  tdesc: string
}

export interface Pl15 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface Position15 {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
}

export interface Prefix15 {
  edesc: string
  prefixId: string
  tdesc: string
}

export interface Status15 {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
}

export interface Time015 {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
}

export interface Apsapprove33 {
  bossId: string
  bu1: Bu116
  bu2: Bu216
  bu3: Bu316
  bu4: Bu416
  bu5: Bu516
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: Job16
  lname: string
  pl: Pl16
  position: Position16
  prefix: Prefix16
  resignDate: string
  startDate: string
  status: Status16
  thFullName: string
  time0: Time016
}

export interface Bu116 {
  bu1id: string
  companyId: string
  edesc: string
  tdesc: string
}

export interface Bu216 {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu316 {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu416 {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu516 {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Job16 {
  edesc: string
  jobCodeId: string
  tdesc: string
}

export interface Pl16 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface Position16 {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
}

export interface Prefix16 {
  edesc: string
  prefixId: string
  tdesc: string
}

export interface Status16 {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
}

export interface Time016 {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
}

export interface Apsapprove43 {
  bossId: string
  bu1: Bu117
  bu2: Bu217
  bu3: Bu317
  bu4: Bu417
  bu5: Bu517
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: Job17
  lname: string
  pl: Pl17
  position: Position17
  prefix: Prefix17
  resignDate: string
  startDate: string
  status: Status17
  thFullName: string
  time0: Time017
}

export interface Bu117 {
  bu1id: string
  companyId: string
  edesc: string
  tdesc: string
}

export interface Bu217 {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu317 {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu417 {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu517 {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Job17 {
  edesc: string
  jobCodeId: string
  tdesc: string
}

export interface Pl17 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface Position17 {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
}

export interface Prefix17 {
  edesc: string
  prefixId: string
  tdesc: string
}

export interface Status17 {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
}

export interface Time017 {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
}

export interface Apsapprove53 {
  bossId: string
  bu1: Bu118
  bu2: Bu218
  bu3: Bu318
  bu4: Bu418
  bu5: Bu518
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: Job18
  lname: string
  pl: Pl18
  position: Position18
  prefix: Prefix18
  resignDate: string
  startDate: string
  status: Status18
  thFullName: string
  time0: Time018
}

export interface Bu118 {
  bu1id: string
  companyId: string
  edesc: string
  tdesc: string
}

export interface Bu218 {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu318 {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu418 {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu518 {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Job18 {
  edesc: string
  jobCodeId: string
  tdesc: string
}

export interface Pl18 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface Position18 {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
}

export interface Prefix18 {
  edesc: string
  prefixId: string
  tdesc: string
}

export interface Status18 {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
}

export interface Time018 {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
}

export interface Apsassessy3 {
  bossId: string
  bu1: Bu119
  bu2: Bu219
  bu3: Bu319
  bu4: Bu419
  bu5: Bu519
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: Job19
  lname: string
  pl: Pl19
  position: Position19
  prefix: Prefix19
  resignDate: string
  startDate: string
  status: Status19
  thFullName: string
  time0: Time019
}

export interface Bu119 {
  bu1id: string
  companyId: string
  edesc: string
  tdesc: string
}

export interface Bu219 {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu319 {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu419 {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu519 {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Job19 {
  edesc: string
  jobCodeId: string
  tdesc: string
}

export interface Pl19 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface Position19 {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
}

export interface Prefix19 {
  edesc: string
  prefixId: string
  tdesc: string
}

export interface Status19 {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
}

export interface Time019 {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
}

export interface MasfromEvaluationAssessment1 {
  apsapprove1Comment: string
  apsapprove1Date: string
  apsapprove1Status: string
  apsapprove2Comment: string
  apsapprove2Date: string
  apsapprove2Status: string
  apsapprove3Comment: string
  apsapprove3Date: string
  apsapprove3Status: string
  apsapprove4Comment: string
  apsapprove4Date: string
  apsapprove4Status: string
  apsapprove5Comment: string
  apsapprove5Date: string
  apsapprove5Status: string
  apsassessyComment: string
  apsassessyDate: string
  apsassessyStatus: string
  averageScore: number
  checkStep: string
  companyId: string
  competencyType: CompetencyType4
  countFormStep: string
  currentStep: string
  evaluationResults: string
  lastStep: string
  lineNo: number
  masfromStatusType: MasfromStatusType2
  weightScore1: number
  weightScore2: number
  weightScore3: number
  weightScore4: number
  weightScore5: number
  plId: string
  sumEvaluationResults: string
  weightedTotal: number
}

export interface CompetencyType4 {
  companyId: string
  competencyTypeId: string
  edesc: string
  expectationLevel: string
  shortName: string
  tdesc: string
  weight: number
}

export interface MasfromStatusType2 {
  code: string
  edesc: string
  tdesc: string
}

export interface MasfromEvaluationRound2 {
  active: number
  apsPeriodEnd: string
  apsPeriodStart: string
  apsyear: string
  checkForm: number
  companyId: string
  edesc: string
  evaluationRoundId: string
  jlId: string
  personalLevel: PersonalLevel3[]
  statusCode: StatusCode2
  statusFrom: StatusFrom2
  tdesc: string
}

export interface PersonalLevel3 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface StatusCode2 {
  code: string
  edesc: string
  tdesc: string
}

export interface StatusFrom2 {
  code: string
  edesc: string
  tdesc: string
}

export interface PersonalLevel4 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface MasfromEvaluationRound3 {
  apsPeriodEnd: string
  apsPeriodStart: string
  apsyear: string
  companyId: string
  edesc: string
  employee: Employee[]
  evaluationRoundId: string
  tdesc: string
}

export interface Employee {
  bossId: string
  bu1: Bu120
  bu2: Bu220
  bu3: Bu320
  bu4: Bu420
  bu5: Bu520
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: Job20
  lname: string
  pl: Pl20
  position: Position20
  prefix: Prefix20
  resignDate: string
  startDate: string
  status: Status20
  thFullName: string
  time0: Time020
}

export interface Bu120 {
  bu1id: string
  companyId: string
  edesc: string
  tdesc: string
}

export interface Bu220 {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu320 {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu420 {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu520 {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Job20 {
  edesc: string
  jobCodeId: string
  tdesc: string
}

export interface Pl20 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface Position20 {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
}

export interface Prefix20 {
  edesc: string
  prefixId: string
  tdesc: string
}

export interface Status20 {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
}

export interface Time020 {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
}

export interface MasfromStatusType3 {
  code: string
  edesc: string
  tdesc: string
}

export interface PersonalLevel5 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface Pms {
  active: boolean
  apsapprove1: Apsapprove14
  apsapprove1Comment: string
  apsapprove1Date: string
  apsapprove1Status: string
  apsapprove2: Apsapprove24
  apsapprove2Comment: string
  apsapprove2Date: string
  apsapprove2Status: string
  apsapprove3: Apsapprove34
  apsapprove3Comment: string
  apsapprove3Date: string
  apsapprove3Status: string
  apsapprove4: Apsapprove44
  apsapprove4Comment: string
  apsapprove4Date: string
  apsapprove4Status: string
  apsapprove5: Apsapprove54
  apsapprove5Comment: string
  apsapprove5Date: string
  apsapprove5Status: string
  apsassessy: Apsassessy4
  apsassessyComment: string
  apsassessyDate: string
  apsassessyStatus: string
  cfrDetail: string
  checkStep: string
  companyId: string
  currentStep: string
  employeeStrengths: string
  gradeScore: string
  improvementPlan: string
  lastStep: string
  learningTopicsForImprovement: string
  learningTopicsForStrengths: string
  learningTopicsForWeaknesses: string
  masfromStatusType: MasfromStatusType4
  netScoreBoss: number
  netScore: number
  part1Detail: Part1Detail[]
  part1Percentage: number
  part1SumScoreBoss: number
  part1SumScore: number
  part2Detail: Part2Detail[]
  part2Percentage: number
  part2SumScoreBoss: number
  part2SumScore: number
  part3Detail: Part3Detail[]
  part3Percentage: number
  part3SumScoreBoss: number
  part3SumScore: number
  part4Detail: Part4Detail[]
  part4Percentage: number
  part4SumScoreBoss: number
  part4SumScore: number
  part5Detail: Part5Detail[]
  part5Percentage: number
  part5SumScoreBoss: number
  part5SumScore: number
  part6Detail: Part6Detail[]
  part6Percentage: number
  part6SumScoreBoss: number
  part6SumScore: number
  part7Detail: Part7Detail[]
  part7Percentage: number
  part7SumScoreBoss: number
  part7SumScore: number
  performanceWeaknesses: string
  personalLevel: PersonalLevel11
  pmsMasfromEvaluationRoundModel: PmsMasfromEvaluationRoundModel
}

export interface Apsapprove14 {
  bossId: string
  bu1: Bu121
  bu2: Bu221
  bu3: Bu321
  bu4: Bu421
  bu5: Bu521
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: Job21
  lname: string
  pl: Pl21
  position: Position21
  prefix: Prefix21
  resignDate: string
  startDate: string
  status: Status21
  thFullName: string
  time0: Time021
}

export interface Bu121 {
  bu1id: string
  companyId: string
  edesc: string
  tdesc: string
}

export interface Bu221 {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu321 {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu421 {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu521 {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Job21 {
  edesc: string
  jobCodeId: string
  tdesc: string
}

export interface Pl21 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface Position21 {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
}

export interface Prefix21 {
  edesc: string
  prefixId: string
  tdesc: string
}

export interface Status21 {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
}

export interface Time021 {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
}

export interface Apsapprove24 {
  bossId: string
  bu1: Bu122
  bu2: Bu222
  bu3: Bu322
  bu4: Bu422
  bu5: Bu522
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: Job22
  lname: string
  pl: Pl22
  position: Position22
  prefix: Prefix22
  resignDate: string
  startDate: string
  status: Status22
  thFullName: string
  time0: Time022
}

export interface Bu122 {
  bu1id: string
  companyId: string
  edesc: string
  tdesc: string
}

export interface Bu222 {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu322 {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu422 {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu522 {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Job22 {
  edesc: string
  jobCodeId: string
  tdesc: string
}

export interface Pl22 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface Position22 {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
}

export interface Prefix22 {
  edesc: string
  prefixId: string
  tdesc: string
}

export interface Status22 {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
}

export interface Time022 {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
}

export interface Apsapprove34 {
  bossId: string
  bu1: Bu123
  bu2: Bu223
  bu3: Bu323
  bu4: Bu423
  bu5: Bu523
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: Job23
  lname: string
  pl: Pl23
  position: Position23
  prefix: Prefix23
  resignDate: string
  startDate: string
  status: Status23
  thFullName: string
  time0: Time023
}

export interface Bu123 {
  bu1id: string
  companyId: string
  edesc: string
  tdesc: string
}

export interface Bu223 {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu323 {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu423 {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu523 {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Job23 {
  edesc: string
  jobCodeId: string
  tdesc: string
}

export interface Pl23 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface Position23 {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
}

export interface Prefix23 {
  edesc: string
  prefixId: string
  tdesc: string
}

export interface Status23 {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
}

export interface Time023 {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
}

export interface Apsapprove44 {
  bossId: string
  bu1: Bu124
  bu2: Bu224
  bu3: Bu324
  bu4: Bu424
  bu5: Bu524
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: Job24
  lname: string
  pl: Pl24
  position: Position24
  prefix: Prefix24
  resignDate: string
  startDate: string
  status: Status24
  thFullName: string
  time0: Time024
}

export interface Bu124 {
  bu1id: string
  companyId: string
  edesc: string
  tdesc: string
}

export interface Bu224 {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu324 {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu424 {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu524 {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Job24 {
  edesc: string
  jobCodeId: string
  tdesc: string
}

export interface Pl24 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface Position24 {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
}

export interface Prefix24 {
  edesc: string
  prefixId: string
  tdesc: string
}

export interface Status24 {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
}

export interface Time024 {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
}

export interface Apsapprove54 {
  bossId: string
  bu1: Bu125
  bu2: Bu225
  bu3: Bu325
  bu4: Bu425
  bu5: Bu525
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: Job25
  lname: string
  pl: Pl25
  position: Position25
  prefix: Prefix25
  resignDate: string
  startDate: string
  status: Status25
  thFullName: string
  time0: Time025
}

export interface Bu125 {
  bu1id: string
  companyId: string
  edesc: string
  tdesc: string
}

export interface Bu225 {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu325 {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu425 {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu525 {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Job25 {
  edesc: string
  jobCodeId: string
  tdesc: string
}

export interface Pl25 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface Position25 {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
}

export interface Prefix25 {
  edesc: string
  prefixId: string
  tdesc: string
}

export interface Status25 {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
}

export interface Time025 {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
}

export interface Apsassessy4 {
  bossId: string
  bu1: Bu126
  bu2: Bu226
  bu3: Bu326
  bu4: Bu426
  bu5: Bu526
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: Job26
  lname: string
  pl: Pl26
  position: Position26
  prefix: Prefix26
  resignDate: string
  startDate: string
  status: Status26
  thFullName: string
  time0: Time026
}

export interface Bu126 {
  bu1id: string
  companyId: string
  edesc: string
  tdesc: string
}

export interface Bu226 {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu326 {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu426 {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Bu526 {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}

export interface Job26 {
  edesc: string
  jobCodeId: string
  tdesc: string
}

export interface Pl26 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface Position26 {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
}

export interface Prefix26 {
  edesc: string
  prefixId: string
  tdesc: string
}

export interface Status26 {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
}

export interface Time026 {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
}

export interface MasfromStatusType4 {
  code: string
  edesc: string
  tdesc: string
}

export interface Part1Detail {
  companyId: string
  groupAssessment1: GroupAssessment1
  lineNo: number
  scoreTopicExpectation: number
  scoreTopicExpectationBoss: number
  weight: number
}

export interface GroupAssessment1 {
  companyId: string
  personalLevelModel: PersonalLevelModel
  pmsGroupAssessment0: PmsGroupAssessment0
  pmsTopic: PmsTopic
}

export interface PersonalLevelModel {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface PmsGroupAssessment0 {
  companyId: string
  personalLevel: PersonalLevel6
  pmsTopic: PmsTopic
}

export interface PersonalLevel6 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface PmsTopic {
  companyId: string
  completionDate: string
  detailUnit: string
  edesc: string
  indicatorsDetail: string
  lineNo: number
  performanceGoalsDetail: string
  pmsTopicId: string
  pmsType: PmsType
  targetAdetail: string
  targetBdetail: string
  targetCdetail: string
  targetDdetail: string
  targetEdetail: string
  tdesc: string
  weight: number
}

export interface PmsType {
  companyId: string
  edesc: string
  pmsTypeId: string
  shortName: string
  tdesc: string
  weight: number
}


export interface PmsType2 {
  companyId: string
  edesc: string
  pmsTypeId: string
  shortName: string
  tdesc: string
  weight: number
}

export interface Part2Detail {
  companyId: string
  groupAssessment1: GroupAssessment12
  lineNo: number
  scoreTopicExpectation: number
  scoreTopicExpectationBoss: number
  weight: number
}

export interface GroupAssessment12 {
  companyId: string
  personalLevelModel: PersonalLevelModel2
  pmsGroupAssessment0: PmsGroupAssessment02
  pmsTopic: PmsTopic
}

export interface PersonalLevelModel2 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface PmsGroupAssessment02 {
  companyId: string
  personalLevel: PersonalLevel7
  pmsTopic: PmsTopic
}

export interface PersonalLevel7 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}


export interface PmsType3 {
  companyId: string
  edesc: string
  pmsTypeId: string
  shortName: string
  tdesc: string
  weight: number
}



export interface PmsType4 {
  companyId: string
  edesc: string
  pmsTypeId: string
  shortName: string
  tdesc: string
  weight: number
}

export interface Part3Detail {
  companyId: string
  groupAssessment1: GroupAssessment13
  lineNo: number
  scoreTopicExpectation: number
  scoreTopicExpectationBoss: number
  weight: number
}

export interface GroupAssessment13 {
  companyId: string
  personalLevelModel: PersonalLevelModel3
  pmsGroupAssessment0: PmsGroupAssessment03
  pmsTopic: PmsTopic
}

export interface PersonalLevelModel3 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface PmsGroupAssessment03 {
  companyId: string
  personalLevel: PersonalLevel8
  pmsTopic: PmsTopic
}

export interface PersonalLevel8 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}


export interface PmsType5 {
  companyId: string
  edesc: string
  pmsTypeId: string
  shortName: string
  tdesc: string
  weight: number
}


export interface PmsType6 {
  companyId: string
  edesc: string
  pmsTypeId: string
  shortName: string
  tdesc: string
  weight: number
}

export interface Part4Detail {
  apsapprove1Comment: string
  apsapprove1Date: string
  apsapprove1Status: string
  apsapprove2Comment: string
  apsapprove2Date: string
  apsapprove2Status: string
  apsapprove3Comment: string
  apsapprove3Date: string
  apsapprove3Status: string
  apsapprove4Comment: string
  apsapprove4Date: string
  apsapprove4Status: string
  apsapprove5Comment: string
  apsapprove5Date: string
  apsapprove5Status: string
  apsassessyComment: string
  apsassessyDate: string
  apsassessyStatus: string
  averageScore: number
  checkStep: string
  companyId: string
  competencyType: CompetencyType5
  countFormStep: string
  currentStep: string
  evaluationResults: string
  lastStep: string
  lineNo: number
  masfromStatusType: MasfromStatusType5
  weightScore1: number
  weightScore2: number
  weightScore3: number
  weightScore4: number
  weightScore5: number
  plId: string
  sumEvaluationResults: string
  weightedTotal: number
}

export interface CompetencyType5 {
  companyId: string
  competencyTypeId: string
  edesc: string
  expectationLevel: string
  shortName: string
  tdesc: string
  weight: number
}

export interface MasfromStatusType5 {
  code: string
  edesc: string
  tdesc: string
}

export interface Part5Detail {
  detailUnit: string
  edesc: string
  performanceTargets: string
  pmsWorkingTimeId: string
  pmsWorkingTimeScore: number
  pmsWorkingTimeScoreBoss: number
  targetADetail: string
  targetBDetail: string
  targetCDetail: string
  targetDDetail: string
  targetEDetail: string
  tdesc: string
  weight: number
}

export interface Part6Detail {
  companyId: string
  groupAssessment1: GroupAssessment14
  lineNo: number
  scoreTopicExpectation: number
  scoreTopicExpectationBoss: number
  weight: number
}

export interface GroupAssessment14 {
  companyId: string
  personalLevelModel: PersonalLevelModel4
  pmsGroupAssessment0: PmsGroupAssessment04
  pmsTopic: PmsTopic
}

export interface PersonalLevelModel4 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface PmsGroupAssessment04 {
  companyId: string
  personalLevel: PersonalLevel9
  pmsTopic: PmsTopic
}

export interface PersonalLevel9 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface PmsType7 {
  companyId: string
  edesc: string
  pmsTypeId: string
  shortName: string
  tdesc: string
  weight: number
}


export interface PmsType8 {
  companyId: string
  edesc: string
  pmsTypeId: string
  shortName: string
  tdesc: string
  weight: number
}

export interface Part7Detail {
  companyId: string
  groupAssessment1: GroupAssessment15
  lineNo: number
  scoreTopicExpectation: number
  scoreTopicExpectationBoss: number
  weight: number
}

export interface GroupAssessment15 {
  companyId: string
  personalLevelModel: PersonalLevelModel5
  pmsGroupAssessment0: PmsGroupAssessment05
  pmsTopic: PmsTopic
}

export interface PersonalLevelModel5 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface PmsGroupAssessment05 {
  companyId: string
  personalLevel: PersonalLevel10
  pmsTopic: PmsTopic
}

export interface PersonalLevel10 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}



export interface PmsType9 {
  companyId: string
  edesc: string
  pmsTypeId: string
  shortName: string
  tdesc: string
  weight: number
}



export interface PmsType10 {
  companyId: string
  edesc: string
  pmsTypeId: string
  shortName: string
  tdesc: string
  weight: number
}

export interface PersonalLevel11 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface PmsMasfromEvaluationRoundModel {
  active: number
  apsPeriodEnd: string
  apsPeriodStart: string
  apsyear: string
  checkForm: number
  companyId: string
  edesc: string
  jlId: string
  personalLevel: PersonalLevel12[]
  pmsEvaluationRoundId: string
  statusCode: StatusCode3
  statusFrom: StatusFrom3
  tdesc: string
}

export interface PersonalLevel12 {
  companyId: string
  edesc: string
  plId: string
  tdesc: string
}

export interface StatusCode3 {
  code: string
  edesc: string
  tdesc: string
}

export interface StatusFrom3 {
  code: string
  edesc: string
  tdesc: string
}
