import { BankBranchModel, MyBankBranchModel } from "./bank-branch.model"
import { BankModel, MyBankModel } from "./bank.model"

export interface BanksModel {
    employeeId: string
    lineNo: string
    accountId: string
    bank: BankModel
    bankBranch: BankBranchModel
}
export class MyBanksModel implements BanksModel {
    employeeId: string
    lineNo: string
    accountId: string
    bank: BankModel
    bankBranch: BankBranchModel
    constructor(data: Partial<BanksModel>) {
        this.employeeId = data.employeeId || ""
        this.lineNo = data.lineNo || ""
        this.accountId = data.accountId || ""
        this.bank = new MyBankModel(data.bank || {})
        this.bankBranch = new MyBankBranchModel(data.bankBranch || {})
    }
}

