import { Component, EventEmitter, Input, Output } from '@angular/core';
import { ToastrService } from 'ngx-toastr';
import { JobModel, MyJobModel } from 'src/app/shared/model/job.model';


@Component({
  selector: 'app-sub-command-structure',
  templateUrl: './sub-command-structure.component.html',
  styleUrls: ['./sub-command-structure.component.scss']
})
export class SubCommandStructureComponent {
  currentPage = 1
    page = Array.from({ length: 1 }, (_, i) => i + 1);
    jobList: JobModel[] = []
    job: JobModel = new MyJobModel({})
    search = ""
    constructor(
      private toastr: ToastrService
    ) { }
    ngOnInit(): void {
    }
    
    searchChange() {
      this.currentPage = 1
      this.page = Array.from({ length: Math.ceil(this.jobListFilter().length / 10) }, (_, i) => i + 1);
    }
    jobListFilter() {
      return this.jobList.filter(x => x.jobid.includes(this.search) ||
        x.tdesc.includes(this.search) ||
        x.edesc.includes(this.search))
    }
    selectJob(job: JobModel) {
      // this.showSuccess()
      this.job = new MyJobModel(job)
    }
  
    showSuccessAdd() {
      this.toastr.success('บันทึกข้อมูลสำเร็จ', 'เเจ้งเตือน', {
        timeOut: 3000,
        positionClass: 'toast-top-right',
      });
    }
  
    showSuccessEdit() {
      this.toastr.success('เเก้ไขข้อมูลสำเร็จ', 'เเจ้งเตือน', {
        timeOut: 3000,
        positionClass: 'toast-top-right',
      });
    }
  
    showSuccessDelete() {
      this.toastr.success('ลบข้อมูลสำเร็จ', 'เเจ้งเตือน', {
        timeOut: 3000,
        positionClass: 'toast-top-right',
      });
    }
    addBu1() {
      // this.bu1Service.post(this.bu1).subscribe((response:any) => {
      //   if (response.success) {
      //     this.getBu1List()
      //   }
      // })
    }
    deleteJob(job: JobModel) {
      // this.bu1Service.delete(new MyBu1Model(bu1)).subscribe((response:any) => {
      //   if (response.success) {
      //     this.getBu1List()
      //   }
      // })
    }
  
  }
  