import { Component, EventEmitter, Input, Output } from '@angular/core';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
interface SubModule {
  title: SafeHtml;
  route?: string;
  file?: string;
}

@Component({
  selector: 'app-employee-self-service',
  templateUrl: './employee-self-service.component.html',
  styleUrls: ['./employee-self-service.component.scss']
})
export class EmployeeSelfServiceComponent {
  // ▶︎ ภาพทางซ้าย (ปรับ path ตามจริง)
  heroImg = 'assets/illustrations/performance.svg';

  // ▶︎ เมนูย่อย (ฝั่งขวา)
  modules: SubModule[] = [
    { title: this.sanitizer.bypassSecurityTrustHtml('ประเมิน<p>Competency & PMS'), route: '/ess/self-evaluation' },
    // { title: this.sanitizer.bypassSecurityTrustHtml('Job Description<p>รายละเอียดของงาน'), file: '2._JD.pdf' },
    { title: this.sanitizer.bypassSecurityTrustHtml('Job Description<p>รายละเอียดของงาน'), route: '/ess/job-description-emp' },
    { title: this.sanitizer.bypassSecurityTrustHtml('Gap Analysis<p>การวิเคราะห์ Gap'), file: '3._Gap_analysis.pdf' },
    { title: this.sanitizer.bypassSecurityTrustHtml('Profile<p>ข้อมูลพนักงาน'), route: '/ess/profile' },
    { title: this.sanitizer.bypassSecurityTrustHtml('Skill Map<p>ทักษะที่จำเป็นสำหรับแต่ละตำแหน่งงาน'), file: '5._skill_map.pdf' },
    { title: this.sanitizer.bypassSecurityTrustHtml('CDR : Competency Dictionary Roadmap<p>หลักสูตรฝึกอบรมตามระบบสมรรถนะ'), file: '6._CDR.pdf' },
    { title: this.sanitizer.bypassSecurityTrustHtml('IDP : Individual Development Plan<p>แผนพัฒนารายบุคคล'), route: '/ess/self-evaluation/idp' },
    { title: this.sanitizer.bypassSecurityTrustHtml('Competency Base Pay<p>ค่าความสามารถพิเศษ') }
  ];
  generalPages = [
    { text: "JD", link: "/ess/job-description-emp" },
    { text: "Profile พนักงาน", link: "/ess/profile" },
    { text: "Job Family", description: "หน้าใหม่ Job Family" },
    { text: "Time Attendance", description: "หน้าใหม่ แสดงข้อมูล TA" },
    { text: "วินัย และการลงโทษ", description: "หน้าใหม่ คล้าย เมนูความดีความผิดของ myHR plus" },
    { text: "ผลงานดีเด่น", description: "หน้าใหม่" },
    { text: "Feedback", link: "/ess/self-evaluation/kpi-sum10" },
    { text: "ดูข้อมูลย้อนหลัง", description: "หน้าใหม่ แสดงListรอบประเมินตั้งแต่รอบล่าสุดถึงย้อนหลัง3ปี" },
    { text: "Calibrate คะแนน", description: "หน้ารายงานที่มีการ Calibrate และแสดงค่า K" },
    { text: "ข้อสอบ", link: "/ess/self-evaluation/com" },
    { text: "Download เอกสาร", description: "เป็น pop up แสดงข้อมูลไฟล์ให้ดาวน์โหลด เหมือนของ myHR plus" }
  ];

  performancePages = [
    [{ text: "ประเมิน", link: "/ess/self-evaluation" },
    { text: "ปัจจัยการประเมิน", link: "/admin/evaluation-factors" },
    { text: "การจัดการการประเมิน", link: "/admin/assessment-management" }],
    [{ text: "รายงาน", description: "ไปที่รายงาน" },
    { text: "แบบฟอร์มการประเมิน", description: "รอทำหน้าใหม่" },
    { text: "ช่วงเวลาการประเมิน", link: "/admin/evaluation-cycle-performance" }],
    [{ text: "PIP (Performance Improvement Plan)", description: "ยังไม่มี รอ Phase 2" }]
  ];

  competencyPages = [
    [{ text: "ประเมิน", link: "/ess/self-evaluation" },
    { text: "การจัดการการประเมิน", link: "/admin/competency-management" },
    { text: "รายงาน", description: "ไปที่รายงาน" }],
    [{ text: "แบบฟอร์มการประเมิน", description: "รอทำหน้าใหม่" },
    { text: "ช่วงเวลาการประเมิน", link: "/admin/evaluation-cycle-manager" },
    { text: "การวิเคราะห์ GAP", description: "รอคอนเฟิร์ม คาดว่าเป็นรายงาน" }],
    [{ text: "Skill Map", description: "รายงาน Skill Map" },
    { text: "Competency Mapping", link: "/ess/competency-mapping" },
    { text: "CDR", description: "หน้าใหม่ แสดง List หลักสูตร" }],
    [{ text: "IDP", link: "/ess/self-evaluation/idp" },
    { text: "Competency Base Pay", description: "รายงาน Competency Base Pay" }]
  ];

  constructor(private sanitizer: DomSanitizer) {

  }
  openReport(file: string) {
    const url = 'assets/reports/' + file;
    window.open(url, '_blank');
  }

}


