import { Injectable } from '@angular/core';
import { environment } from 'src/environments/environment';
import { DashboardWidgetModel } from '../model/widget.model';
import { Observable } from 'rxjs';
import { HttpClient } from '@angular/common/http';

@Injectable({
  providedIn: 'root'
})
export class WidgetService {
  api = "/dashboard"
  baseUrl = environment.portal + this.api

  constructor(private http: HttpClient) { }

  getDashboards(): Observable<DashboardWidgetModel[]> {
    return this.http.get<DashboardWidgetModel[]>(`${this.baseUrl}/lists/search?application=MYSKILL-X`);
  }
}
