import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { AlertModel } from '../model/alert.model';
import { PmstypeModel } from '../model/pmstype.model';
@Injectable({
  providedIn: 'root'
})
export class PmstypeService {
  api = "/pmstype"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getById(pmsTypeId: string): Observable<PmstypeModel> {
    return this.http.get<PmstypeModel>(this.urlApi + "/" + pmsTypeId)
  }
  getList(): Observable<PmstypeModel[]> {
    return this.http.get<PmstypeModel[]>(this.urlApi + "/lists")
  }
  post(body: PmstypeModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi, body)
  }
  delete(body: PmstypeModel | PmstypeModel[]): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi, options)
  }
}