import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { EmpTypeModel } from '../model/employee-type.model';
import { AlertModel } from '../model/alert.model';

@Injectable({
    providedIn: 'root'
})
export class EmpTypeService {
    api = "/employee-type"
    urlApi = environment.baseUrl + this.api
    constructor(private http: HttpClient) {
    }
    getList(): Observable<EmpTypeModel[]> {
        return this.http.get<EmpTypeModel[]>(this.urlApi + "/lists")
    }
    getById(codeId: string): Observable<EmpTypeModel> {
        return this.http.get<EmpTypeModel>(this.urlApi + "/" + codeId)
    }
    post(body: EmpTypeModel): Observable<AlertModel> {
        return this.http.post<AlertModel>(this.urlApi, body)
    }
    delete(body: EmpTypeModel | EmpTypeModel[]): Observable<AlertModel> {
        const options = {
            headers: new HttpHeaders({
                "Content-Type": "application/json",
            }),
            body: body
        };
        return this.http.delete<AlertModel>(this.urlApi, options)
    }
}
