import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { CompanyModel } from '../model/company.model';
import { AlertModel } from '../model/alert.model';
@Injectable({
  providedIn: 'root'
})
export class CompanyService {
  api = "/company"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getById(companyId: string): Observable<CompanyModel> {
    return this.http.get<CompanyModel>(this.urlApi + "/" + companyId)
  }
  getList(): Observable<CompanyModel[]> {
    return this.http.get<CompanyModel[]>(this.urlApi + "/lists")
  }
  post(body: CompanyModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi, body)
  }
  delete(body: CompanyModel | CompanyModel[]): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi, options)
  }
}