import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { Bu4Model } from '../model/bu4.model';
import { AlertModel } from '../model/alert.model';
@Injectable({
    providedIn: 'root'
})
export class Bu4Service {
    api = "/bu4"
    urlApi = environment.baseUrl + this.api
    constructor(private http: HttpClient) {
    }
    getList(): Observable<Bu4Model[]> {
        return this.http.get<Bu4Model[]>(this.urlApi + "/lists")
    }
    getListByParent(bu3id: string): Observable<Bu4Model[]> {
        return this.http.get<Bu4Model[]>(environment.baseUrl + "/bu3/parent/" + bu3id)
    }
    getById(bu4id: string): Observable<Bu4Model> {
        return this.http.get<Bu4Model>(this.urlApi + "/" + bu4id)
    }
    post(body: Bu4Model): Observable<AlertModel> {
        return this.http.post<AlertModel>(this.urlApi, body)
    }
    delete(body: Bu4Model[]): Observable<AlertModel> {
        const options = {
            headers: new HttpHeaders({
                "Content-Type": "application/json",
            }),
            body: body
        };
        return this.http.delete<AlertModel>(this.urlApi, options)
    }
}
