export interface ComEvaluationFactorsModel {
    comEvaluationFactorsList: ComEvaluationFactorsDetailModel[]
    companyId: string
    jl: JlModel
}
export class MyComEvaluationFactorsModel implements ComEvaluationFactorsModel {
    comEvaluationFactorsList: ComEvaluationFactorsDetailModel[]
    companyId: string
    jl: JlModel
    constructor(data?: Partial<ComEvaluationFactorsModel>) {
        this.jl = new MyJlModel(data?.jl)
        this.companyId = data?.companyId || ""
        this.comEvaluationFactorsList = (data?.comEvaluationFactorsList || []).map(x => new MyComEvaluationFactorsDetailModel(x)) || []
    }
}

export interface ComEvaluationFactorsDetailModel {
    companyId: string
    competencyType: CompetencyTypeModel
    comScore: number
}

export class MyComEvaluationFactorsDetailModel implements ComEvaluationFactorsDetailModel {
    companyId: string
    competencyType: CompetencyTypeModel
    comScore: number
    constructor(data?: Partial<ComEvaluationFactorsDetailModel>) {
        this.companyId = data?.companyId || ""
        this.competencyType = new MyCompetencyTypeModel(data?.competencyType)
        this.comScore = data?.comScore ?? 0
    }
}

export interface CompetencyTypeModel {
    companyId: string
    competencyTypeId: string
    edesc: string
    expectationLevel: string
    shortName: string
    tdesc: string
    weight: number
}

export class MyCompetencyTypeModel implements CompetencyTypeModel {
    companyId: string
    competencyTypeId: string
    edesc: string
    expectationLevel: string
    shortName: string
    tdesc: string
    weight: number

    constructor(data?: Partial<CompetencyTypeModel>) {
        this.companyId = data?.companyId || ""
        this.competencyTypeId = data?.competencyTypeId || ""
        this.edesc = data?.edesc || ""
        this.expectationLevel = data?.expectationLevel || ""
        this.shortName = data?.shortName || ""
        this.tdesc = data?.tdesc || ""
        this.weight = data?.weight ?? 0
    }
}


export interface JlModel {
    companyId: string
    edesc: string
    grade: GradeModel
    plId: string
    tdesc: string
}

export class MyJlModel implements JlModel {
    companyId: string
    edesc: string
    grade: GradeModel
    plId: string
    tdesc: string

    constructor(data?: Partial<JlModel>) {
        this.companyId = data?.companyId || ""
        this.edesc = data?.edesc || ""
        this.grade = new MyGradeModel(data?.grade)
        this.plId = data?.plId || ""
        this.tdesc = data?.tdesc || ""
    }
}


export interface GradeModel {
    countAverage: string
    countEmployee: string
    countScore: string
    gradeDetail: GradeDetailModel[]
}

export class MyGradeModel implements GradeModel {
    countAverage: string
    countEmployee: string
    countScore: string
    gradeDetail: GradeDetailModel[]

    constructor(data?: Partial<GradeModel>) {
        this.countAverage = data?.countAverage || ""
        this.countEmployee = data?.countEmployee || ""
        this.countScore = data?.countScore || ""
        this.gradeDetail = (data?.gradeDetail || []).map(item => new MyGradeDetailModel(item))
    }
}


export interface GradeDetailModel {
    companyId: string
    countAverage: string
    countEmployee: string
    countScore: string
    edesc: string
    gradeDetail: string
    gradeId: string
    gradeMaxScore: number
    gradeMinScore: number
    tdesc: string
    weight: number
}

export class MyGradeDetailModel implements GradeDetailModel {
    companyId: string
    countAverage: string
    countEmployee: string
    countScore: string
    edesc: string
    gradeDetail: string
    gradeId: string
    gradeMaxScore: number
    gradeMinScore: number
    tdesc: string
    weight: number

    constructor(data?: Partial<GradeDetailModel>) {
        this.companyId = data?.companyId || ""
        this.countAverage = data?.countAverage || ""
        this.countEmployee = data?.countEmployee || ""
        this.countScore = data?.countScore || ""
        this.edesc = data?.edesc || ""
        this.gradeDetail = data?.gradeDetail || ""
        this.gradeId = data?.gradeId || ""
        this.gradeMaxScore = data?.gradeMaxScore ?? 0
        this.gradeMinScore = data?.gradeMinScore ?? 0
        this.tdesc = data?.tdesc || ""
        this.weight = data?.weight ?? 0
    }
}
