import { ChangeDetectorRef, Component, EventEmitter, Input, Output, SimpleChanges, ViewChild } from "@angular/core";
import { MatDialog, MatDialogRef } from "@angular/material/dialog";
import { Router, ActivatedRoute } from "@angular/router";
import { TranslateService } from "@ngx-translate/core";
import { AppraisalKpiSettingEmpModel, MyAppraisalKpiSettingEmpModel, MyPmsTypeModel, MyTopicModel, PmsTypeModel, TopicModel } from "src/app/shared/model/appraisal-kpi-setting-emp.model";
import { EmployeeModel, MyEmployeeModel } from "src/app/shared/model/employee.model";
import { AppraisalService } from "src/app/shared/services/appraisal.service";
import { EmployeeService } from "src/app/shared/services/employee.service";
import { FileService } from "src/app/shared/services/file.service";
import { PmstypeService } from "src/app/shared/services/pmstype.service";
import { TokenService } from "src/app/shared/services/token.service";
import { ToastrService } from 'ngx-toastr';
import Swal from 'sweetalert2';
import { Column, ColumnMenuClickEventArgs, ColumnModel, ExcelExportProperties, FilterSettingsModel, GridComponent, GroupSettingsModel, LoadingIndicatorModel, SelectionSettingsModel } from "@syncfusion/ej2-angular-grids";
import { Query } from '@syncfusion/ej2-data';
import { setCulture } from '@syncfusion/ej2-base';
@Component({
  selector: 'app-post-evaluation-tracking',
  templateUrl: './post-evaluation-tracking.component.html',
  styleUrls: ['./post-evaluation-tracking.component.scss']
})
export class PostEvaluationTrackingComponent {
  @Output() sendPathTitle: EventEmitter<string[]> = new EventEmitter<string[]>();

  currentTab = 1
  onSendPathTitle(pathTitle: string) {
    this.sendPathTitle.emit(['menu.Organization', 'menu.Company', 'BusinessUnit', pathTitle])
  }

}
