import { ChangeDetectorRef, Component, EventEmitter, Input, Output } from '@angular/core';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { TranslateService } from '@ngx-translate/core';
import { DocumentManagerModel, MyDocumentManagerModel } from 'src/app/shared/model/document-manager.model';
import { DocumentManagerService } from 'src/app/shared/services/documents.service';
import { FileService } from 'src/app/shared/services/file.service';
import Swal from 'sweetalert2';
interface SubModule {
  title: SafeHtml;
  route?: string;
  file?: string;
}

@Component({
  selector: 'app-employee-self-service',
  templateUrl: './employee-self-service.component.html',
  styleUrls: ['./employee-self-service.component.scss']
})
export class EmployeeSelfServiceComponent {
  // ▶︎ ภาพทางซ้าย (ปรับ path ตามจริง)
  heroImg = 'assets/illustrations/performance.svg';

  // ▶︎ เมนูย่อย (ฝั่งขวา)
  modules: SubModule[] = [
    { title: this.sanitizer.bypassSecurityTrustHtml('ประเมิน<p>Competency & PMS'), route: '/ess/self-evaluation' },
    // { title: this.sanitizer.bypassSecurityTrustHtml('Job Description<p>รายละเอียดของงาน'), file: '2._JD.pdf' },
    { title: this.sanitizer.bypassSecurityTrustHtml('Job Description<p>รายละเอียดของงาน'), route: '/ess/job-description-emp' },
    { title: this.sanitizer.bypassSecurityTrustHtml('Gap Analysis<p>การวิเคราะห์ Gap'), file: '3._Gap_analysis.pdf' },
    { title: this.sanitizer.bypassSecurityTrustHtml('Profile<p>ข้อมูลพนักงาน'), route: '/ess/profile' },
    { title: this.sanitizer.bypassSecurityTrustHtml('Skill Map<p>ทักษะที่จำเป็นสำหรับแต่ละตำแหน่งงาน'), file: '5._skill_map.pdf' },
    { title: this.sanitizer.bypassSecurityTrustHtml('CDR : Competency Dictionary Roadmap<p>หลักสูตรฝึกอบรมตามระบบสมรรถนะ'), file: '6._CDR.pdf' },
    { title: this.sanitizer.bypassSecurityTrustHtml('IDP : Individual Development Plan<p>แผนพัฒนารายบุคคล'), route: '/ess/self-evaluation/idp' },
    { title: this.sanitizer.bypassSecurityTrustHtml('Competency Base Pay<p>ค่าความสามารถพิเศษ') }
  ];
  generalPages = [
    { text: "JD", link: "/ess/job-description-emp" },
    { text: "Profile พนักงาน", link: "/ess/profile" },
    { text: "Job Family", link: "/ess/job-family-mapping" },
    { text: "Time Attendance", description: "หน้าใหม่ แสดงข้อมูล TA" },
    { text: "วินัย และการลงโทษ", link: "/ess/disciplinary-action" },
    { text: "ผลงานดีเด่น", link: "/ess/outstanding-performance" },
    { text: "Feedback", link: "/ess/self-evaluation/kpi-sum10" },
    { text: "ดูข้อมูลย้อนหลัง", description: "หน้าใหม่ แสดงListรอบประเมินตั้งแต่รอบล่าสุดถึงย้อนหลัง3ปี" },
    { text: "Calibrate คะแนน", description: "หน้ารายงานที่มีการ Calibrate และแสดงค่า K" },
    { text: "ข้อสอบ", link: "/ess/self-evaluation/com" },
    { text: "Download เอกสาร", description: "เป็น pop up แสดงข้อมูลไฟล์ให้ดาวน์โหลด เหมือนของ myHR plus" }
  ];

  performancePages = [
    [{ text: "ประเมิน", link: "/ess/self-evaluation" },
    { text: "ปัจจัยการประเมิน", link: "/admin/evaluation-factors" },
    { text: "การจัดการการประเมิน", link: "/admin/assessment-management" }],
    [{ text: "รายงาน", description: "ไปที่รายงาน" },
    { text: "แบบฟอร์มการประเมิน", description: "รอทำหน้าใหม่" },
    { text: "ช่วงเวลาการประเมิน", link: "/admin/evaluation-cycle-performance" }],
    [{ text: "PIP (Performance Improvement Plan)", description: "ยังไม่มี รอ Phase 2" }]
  ];

  competencyPages = [
    [{ text: "ประเมิน", link: "/ess/self-evaluation" },
    { text: "การจัดการการประเมิน", link: "/admin/competency-management" },
    { text: "รายงาน", description: "ไปที่รายงาน" }],
    [{ text: "แบบฟอร์มการประเมิน", description: "รอทำหน้าใหม่" },
    { text: "ช่วงเวลาการประเมิน", link: "/admin/evaluation-cycle-manager" },
    { text: "การวิเคราะห์ GAP", description: "รอคอนเฟิร์ม คาดว่าเป็นรายงาน" }],
    [{ text: "Skill Map", description: "รายงาน Skill Map" },
    { text: "Competency Mapping", link: "/ess/competency-mapping" },
    { text: "CDR", description: "หน้าใหม่ แสดง List หลักสูตร" }],
    [{ text: "IDP", link: "/ess/self-evaluation/idp" },
    { text: "Competency Base Pay", description: "รายงาน Competency Base Pay" }]
  ];


  documentManager: { loading: boolean, dataList: DocumentManagerModel[] } = { loading: false, dataList: [] }

  constructor(private sanitizer: DomSanitizer,
    private fileService: FileService,
    private cdr: ChangeDetectorRef,
    private translateService: TranslateService,
    private documentManagerService: DocumentManagerService
  ) {

  }

  ngOnInit(): void {
    this.getDocumentManagerList()
  }

  getDocumentManagerList() {
    this.documentManager.loading = true
    this.documentManagerService.getList().subscribe({
      next: response => {
        this.documentManager.dataList = response.map(x => {
          return new MyDocumentManagerModel(x)
        })
        this.documentManager.loading = false
        this.cdr.detectChanges();
      }, error: error => {
        this.documentManager.loading = false
        console.error('Error fetching employee types:', error);
        this.cdr.detectChanges()
      }
    })
  }
  openReport(file: string) {
    const url = 'assets/reports/' + file;
    window.open(url, '_blank');
  }

  downloadFile(fileName: string) {
    this.fileService.downloadFiles(fileName).subscribe({
      next: response => {
        const url = window.URL.createObjectURL(response);
        const a = document.createElement("a");
        a.href = url;
        a.download = fileName;
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        window.URL.revokeObjectURL(url);
        this.cdr.detectChanges()
      }, error: error => {
        this.showAlert(error.message, 'error')
        this.cdr.detectChanges()
      }
    })
  }

  showAlert(text: string, type: 'success' | 'error') {
    Swal.fire({
      icon: type,
      title: 'แจ้งเตือน',
      text: text,
      showCancelButton: false,
      confirmButtonText: 'ยืนยัน',
    })
  }


  translateText(th?: string, en?: string) {
    return this.translateService.getCurrentLang() == 'th' ? (th || '') : (en || '')
  }

}


