import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { BranchModel } from '../model/branch.model';

@Injectable({
    providedIn: 'root'
})
export class BranchService {
    api = "/branch"
    urlApi = environment.baseUrl + this.api
    constructor(private http: HttpClient) {
    }
    getList(): Observable<BranchModel[]> {
        return this.http.get<BranchModel[]>(this.urlApi + "/lists")
    }
    getById(branchId: string): Observable<BranchModel> {
        return this.http.get<BranchModel>(this.urlApi + "/" + branchId)
    }
    // post(body: BranchModel): Observable<AlertModel> {
    //     return this.http.post<AlertModel>(this.urlApi, body)
    // }
    // delete(body: BranchModel | BranchModel[]): Observable<AlertModel> {
    //     const options = {
    //         headers: new HttpHeaders({
    //             "Content-Type": "application/json",
    //         }),
    //         body: body
    //     };
    //     return this.http.delete<AlertModel>(this.urlApi, options)
    // }
}
