import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { AlertModel } from '../model/alert.model';
import { EvaluationCycleModel } from '../model/evaluation-cycle.model';
import { AppraisalModel } from '../model/appraisal.model';
import { AppraisalRoundModel } from '../model/appraisal-aps.model';
import { EvaluationModal } from '../model/evaluation-form.modal';

@Injectable({
  providedIn: 'root'
})
export class EvaluationAssessmentService {
  api = "/evaluation-assessment"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getList(): Observable<EvaluationCycleModel[]> {
    return this.http.get<EvaluationCycleModel[]>(this.urlApi + "/lists")
  }
  getById(evaluationRoundId: string, apsyear: string): Observable<any[]> {
    return this.http.get<any[]>(this.urlApi + "/" + evaluationRoundId + "/" + apsyear)
  }
  getApsassessy(evaluationRoundId: string, apsassessy: string, apsyear: string): Observable<EvaluationModal> {
    return this.http.get<EvaluationModal>(this.urlApi + "/" + evaluationRoundId + "/" + apsassessy + "/" + apsyear)
  }
  getApsassessyMini(evaluationRoundId: string, apsassessy: string, apsyear: string): Observable<AppraisalRoundModel[]> {
    return this.http.get<AppraisalRoundModel[]>(this.urlApi + "/mini/" + evaluationRoundId + "/" + apsassessy + "/" + apsyear)
  }
  getIndicators(jobCodeId: string): Observable<AppraisalRoundModel[]> {
    return this.http.get<AppraisalRoundModel[]>(this.urlApi + "/indicators/list/" + jobCodeId)
  }
  post(body: AppraisalModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi, body)
  }
  postList(body: any): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi + "/create-list", body)
  }
  delete(body: EvaluationCycleModel | EvaluationCycleModel[]): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi, options)
  }

  deletemMini(body: AppraisalRoundModel[], apsassessy: string, evaluationRoundId: string): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi + '/delete-mini' + "/" + apsassessy + "/" + evaluationRoundId, options)
  }
}
