import { HttpClient } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { AlertModel } from '../model/alert.model';
import { IdpFormModel } from '../model/idp-form.model';
@Injectable({
  providedIn: 'root'
})
export class EvaluationIdpService {
  api = "/evaluation-Idp"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getFormIdp(evaluationRoundId: string, employeeId: string): Observable<IdpFormModel> {
    return this.http.get<IdpFormModel>(this.urlApi + "/" + evaluationRoundId + "/" + employeeId)
  }
  postIdp(body: IdpFormModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi + "/", body)
  }
}