import { LevelModel, MyLevelModel } from "./level.model";
import { EmployeeModel, MyEmployeeModel } from "./employee.model";
import { MyRoleModel, RoleModel } from "./role.model";

export interface UserModel {
    usernameId: string
    empId: string
    companyId: string
    userRole: string
    userLevel: string
    lang: string
    passwordStatus: string
    expireDate: string
    adAccount: string
    status: string
    role: RoleModel
    level: LevelModel
    employee: EmployeeModel
}

export class MyUserModel implements UserModel {
    usernameId: string
    empId: string
    companyId: string
    userRole: string
    userLevel: string
    lang: string
    passwordStatus: string
    expireDate: string
    adAccount: string
    status: string
    role: RoleModel
    level: LevelModel
    employee: EmployeeModel
    constructor(data?: Partial<UserModel>) {
        this.usernameId = data?.usernameId || ""
        this.empId = data?.empId || ""
        this.companyId = data?.companyId || ""
        this.userRole = data?.userRole || ""
        this.userLevel = data?.userLevel || ""
        this.lang = data?.lang || ""
        this.passwordStatus = data?.passwordStatus || ""
        this.expireDate = data?.expireDate || ""
        this.adAccount = data?.adAccount || ""
        this.status = data?.status || ""
        this.role = new MyRoleModel(data?.role)
        this.level = new MyLevelModel(data?.level)
        this.employee = new MyEmployeeModel(data?.employee)
    }
}

