import { EmployeeModel, MyEmployeeModel } from "./employee.model";
import { JobcodeModel, MyJobcodeModel } from "./jobcode.model";
import { MyPLModel, PLModel } from "./pl.model";


export interface GroupApproveModel {
    personalLevel: PLModel;
    jd: JobcodeModel;
    apsassessy: EmployeeModel;
    companyId: string;
    apsapprove1: EmployeeModel;
    apsapprove2: EmployeeModel;
    apsapprove3: EmployeeModel;
    apsapprove4: EmployeeModel;
    apsapprove5: EmployeeModel;
}


export class MyGroupApproveModel implements GroupApproveModel {
    personalLevel: PLModel;
    jd: JobcodeModel;
    apsassessy: EmployeeModel
    companyId: string;
    apsapprove1: EmployeeModel;
    apsapprove2: EmployeeModel;
    apsapprove3: EmployeeModel;
    apsapprove4: EmployeeModel;
    apsapprove5: EmployeeModel;
    constructor(data: Partial<GroupApproveModel> = {}) {
        this.personalLevel = new MyPLModel(data.personalLevel || {});
        this.jd = new MyJobcodeModel(data.jd || {});
        this.apsassessy = new MyEmployeeModel(data.apsassessy || {})
        this.companyId = data.companyId || '';
        this.apsapprove1 = new MyEmployeeModel(data.apsapprove1 || {});
        this.apsapprove2 = new MyEmployeeModel(data.apsapprove2 || {});
        this.apsapprove3 = new MyEmployeeModel(data.apsapprove3 || {});
        this.apsapprove4 = new MyEmployeeModel(data.apsapprove4 || {});
        this.apsapprove5 = new MyEmployeeModel(data.apsapprove5 || {});
    }
}