import { Component } from '@angular/core';
import { EChartsOption } from 'echarts';
@Component({
  selector: 'app-report-pms-1',
  templateUrl: './report-pms-1.component.html',
  styleUrls: ['./report-pms-1.component.scss']
})
export class ReportPms1Component {
  // ── Mock chart data ──
  chartOpt: EChartsOption = {
    grid: { top: 20, left: 45, right: 10, bottom: 30 },
    tooltip: { trigger: 'axis' },
    xAxis: {
      type: 'category',
      data: ['A', 'B', 'C', 'D', 'E'],
      axisLabel: { fontFamily: 'Inter', fontWeight: 600 }
    },
    yAxis: { type: 'value', splitLine: { show: false } },
    series: [
      {
        name: 'จำนวนพนักงาน',
        type: 'bar',
        data: [1, 7, 5, 0, 0],
        itemStyle: { color: '#1d4ed8', borderRadius: [4, 4, 0, 0] },
        barWidth: '40%'
      },
      {
        name: 'เทรนด์',
        type: 'line',
        data: [1, 7, 5, 0, 0],
        smooth: true,
        lineStyle: { width: 3, color: '#0ea5e9' },
        symbolSize: 8,
        itemStyle: { color: '#0ea5e9' }
      }
    ]
  };

  // ── Mock table rows ──
  rows = [
    { level: 'E4', A: 0, B: 0, C: 0, D: 0, E: 0, sum: 0 },
    { level: 'E3', A: 0, B: 0, C: 0, D: 0, E: 0, sum: 0 },
    { level: 'S3', A: 1, B: 25, C: 3, D: 75, E: 0, sum: 4 },
    { level: 'S2', A: 1, B: 25, C: 3, D: 75, E: 0, sum: 4 },
    { level: 'S1', A: 1, B: 0, C: 1, D: 50, E: 0, sum: 2 },
    // ...
  ];

  /** คำนวณ footer รวมอัตโนมัติ */
  get grand() {
    const g = { level: 'Total', A: 0, B: 0, C: 0, D: 0, E: 0, sum: 0 };
    this.rows.forEach(r => {
      g.A += r.A; g.B += r.B; g.C += r.C; g.D += r.D; g.E += r.E; g.sum += r.sum;
    });
    return g;
  }
}
