import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { AlertModel } from '../model/alert.model';
import { UserModel } from '../model/user.model';
import { RoleModel } from '../model/role.model';
@Injectable({
  providedIn: 'root'
})
export class UserService {
  api = "/user"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getList(pwdempty?: string): Observable<UserModel[]> {
    return this.http.get<UserModel[]>(this.urlApi + "/lists" + (pwdempty ? '?pwdempty=' + pwdempty : ""))
  }
  getRoleList(): Observable<RoleModel[]> {
    return this.http.get<RoleModel[]>(this.urlApi + "/role/lists")
  }
  getLevelList(): Observable<RoleModel[]> {
    return this.http.get<RoleModel[]>(this.urlApi + "/level/lists")
  }
  checkUser(username: string): Observable<AlertModel> {
    return this.http.get<AlertModel>(this.urlApi + "/validate-username/" + username)
  }
  changePassword(body: {
    usernameId: string,
    empId: string,
    companyId: string,
    oldPassword: string,
    newPassword: string,
  }): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi + "/change-password", body)
  }
  post(body: UserModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi + "/create", body)
  }
  delete(body: UserModel[]): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi + '/delete', options)
  }
}
