import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { AlertModel } from '../model/alert.model';
@Injectable({
  providedIn: 'root'
})
export class FileService {
  constructor(private http: HttpClient) {
  }
  uploadFiles(formData: any): Observable<AlertModel> {
    return this.http.post<AlertModel>(environment.baseUrl + '/files/upload', formData)
  }
  downloadFiles(filename: string) {
    return this.http.get(environment.baseUrl + '/files/download/' + filename, { responseType: "blob" })
  }
  uploadExcel(formData: any, table: string): Observable<AlertModel> {
    return this.http.post<AlertModel>(environment.baseUrl + '/import/excel/' + table, formData)
  }
  downloadTemplate(fileName: string) {
    return this.http.get("/assets/template/" + fileName, { responseType: "blob" })
  }

  uploadImg(formData: any): Observable<AlertModel> {
    return this.http.post<AlertModel>(environment.baseUrl + '/employee/upload-image', formData)
  }
  getImg(filename?: string) {
    return filename ? environment.baseUrl + '/employee/image/' + filename : ''
  }
}
