import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { EmpGroupModel } from '../model/emp-group.model';
import { AlertModel } from '../model/alert.model';

@Injectable({
    providedIn: 'root'
})
export class EmpGroupService {
    api = "/emp-group"
    urlApi = environment.baseUrl + this.api
    constructor(private http: HttpClient) {
    }
    getList(): Observable<EmpGroupModel[]> {
        return this.http.get<EmpGroupModel[]>(this.urlApi + "/lists")
    }
    getById(groupId: string): Observable<EmpGroupModel> {
        return this.http.get<EmpGroupModel>(this.urlApi + "/" + groupId)
    }
    post(body: EmpGroupModel): Observable<AlertModel> {
        return this.http.post<AlertModel>(this.urlApi, body)
      }
    delete(body: EmpGroupModel | EmpGroupModel[]): Observable<AlertModel> {
        const options = {
          headers: new HttpHeaders({
            "Content-Type": "application/json",
          }),
          body: body
        };
    return this.http.delete<AlertModel>(this.urlApi, options)
    }
}
