import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { AlertModel } from '../model/alert.model';
import { DocumentManagerModel } from '../model/document-manager.model';
@Injectable({
  providedIn: 'root'
})
export class DocumentManagerService {
  api = "/documents"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getById(userLevel: string): Observable<DocumentManagerModel> {
    return this.http.get<DocumentManagerModel>(this.urlApi + "/" + userLevel)
  }
  getList(): Observable<DocumentManagerModel[]> {
    return this.http.get<DocumentManagerModel[]>(this.urlApi + "/lists")
  }
  getListActive(): Observable<DocumentManagerModel[]> {
    return this.http.get<DocumentManagerModel[]>(this.urlApi + "/documents/lists/active")
  }
  post(body: DocumentManagerModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi + '/', body)
  }
  delete(body: DocumentManagerModel[]): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi + "/", options)
  }
}