import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Observable } from 'rxjs';
import { TemplateFileMiniModel } from '../model/template-file-mini.model';
import { AlertModel } from '../model/alert.model';
import { environment } from 'src/environments/environment';

@Injectable({
  providedIn: 'root'
})
export class CustomCubeService {

  constructor(private http: HttpClient,
  ) { }

  getExcelColumn(body: {
    templateId: string,
    fileName: string,
  }) {
    return this.http.post(environment.portal + "/customcube/get-excel-column?companyid=eb2f4f30-edaf-11ee-a69a-c7680edc0e47", body)
  }
  getExcelData(body: any) {
    return this.http.post(environment.portal + "/customcube/get-excel-data?companyid=eb2f4f30-edaf-11ee-a69a-c7680edc0e47", body)
  }
  saveExcelPerspective(body: {
    templateId: string,
    fileName: string,
    dataGridStr: string,
    pivotStr: string,
  }): Observable<AlertModel> {
    return this.http.post<AlertModel>(environment.portal + "/customcube/save-excel-perspective?companyid=eb2f4f30-edaf-11ee-a69a-c7680edc0e47", body)
  }
  getExcelPerspective(body: {
    templateId: string,
    fileName: string,
  }) {
    return this.http.post(environment.portal + "/customcube/get-excel-perspective?companyid=eb2f4f30-edaf-11ee-a69a-c7680edc0e47", body)
  }
}