import { CompetencyIndicatorsCourses1MiniModel, MyCompetencyIndicatorsCourses1MiniModel } from "./competency-indicators-courses1-mini.model"
import { GroupAssessmentMiniModel, MyGroupAssessmentMiniModel } from "./group-assessment-mini.model"
import { MyPLModel, PLModel } from "./pl.model"

export interface GroupAssessment1Model {
    personalLevelModel: PLModel
    competencyIndicatorsCourses1Mini: CompetencyIndicatorsCourses1MiniModel
    companyId: string
    groupAssessmentMini: GroupAssessmentMiniModel
}


export class MyGroupAssessment1Model implements GroupAssessment1Model {
    personalLevelModel: PLModel
    competencyIndicatorsCourses1Mini: CompetencyIndicatorsCourses1MiniModel
    companyId: string
    groupAssessmentMini: GroupAssessmentMiniModel
    constructor(data?: Partial<GroupAssessment1Model>) {
        this.personalLevelModel = new MyPLModel(data?.personalLevelModel)
        this.competencyIndicatorsCourses1Mini = new MyCompetencyIndicatorsCourses1MiniModel(data?.competencyIndicatorsCourses1Mini)
        this.companyId = data?.companyId || ""
        this.groupAssessmentMini = new MyGroupAssessmentMiniModel(data?.groupAssessmentMini)
    }
}

