import { GroupAssessment1ListModel, MyGroupAssessment1ListModel } from "./group-assessment1-list.model"
import { JobcodeModel, MyJobcodeModel } from "./jobcode.model"
import { MyPLModel, PLModel } from "./pl.model"

export interface GroupAssessmentModel {
    personalLevel: PLModel
    jd: JobcodeModel
    jlId: string
    companyId: string
    groupAssessment1List: GroupAssessment1ListModel[]
}


export class MyGroupAssessmentModel implements GroupAssessmentModel {
    personalLevel: PLModel
    jd: JobcodeModel
    jlId: string
    companyId: string
    groupAssessment1List: GroupAssessment1ListModel[]
    constructor(data?: Partial<GroupAssessmentModel>) {
        this.personalLevel = new MyPLModel(data?.personalLevel || {})
        this.jd = new MyJobcodeModel(data?.jd || {})
        this.jlId = data?.jlId || ""
        this.companyId = data?.companyId || ""
        this.groupAssessment1List = data?.groupAssessment1List?.map(x => new MyGroupAssessment1ListModel(x)) || []
    }
}

