import { CompetencytypeModel, MyCompetencytypeModel } from "./competencytype.model"
import { MyStatusCodeModel, StatusCodeModel } from "./status-code.model"

export interface AppraisalPmsFormModel {
  personalLevel: PersonalLevel
  pmsMasfromEvaluationRoundModel: PmsMasfromEvaluationRoundModel
  companyId: string
  active: boolean
  masfromStatusType: MasfromStatusType
  currentStep: string
  lastStep: string
  checkStep: string
  apsassessy: Apsassessy
  apsapprove1: Apsapprove1
  apsapprove2: Apsapprove2
  apsapprove3: Apsapprove3
  apsapprove4: Apsapprove4
  apsapprove5: Apsapprove5
  apsassessyStatus: string
  apsapprove1Status: string
  apsapprove2Status: string
  apsapprove3Status: string
  apsapprove4Status: string
  apsapprove5Status: string
  employeeStrengths: string
  learningTopicsForStrengths: string
  performanceWeaknesses: string
  learningTopicsForWeaknesses: string
  improvementPlan: string
  learningTopicsForImprovement: string
  apsassessyComment: string
  apsapprove1Comment: string
  apsapprove2Comment: string
  apsapprove3Comment: string
  apsapprove4Comment: string
  apsapprove5Comment: string
  apsassessyDate: string
  apsapprove1Date: string
  apsapprove2Date: string
  apsapprove3Date: string
  apsapprove4Date: string
  apsapprove5Date: string
  part1Percentage: number
  part2Percentage: number
  part3Percentage: number
  part4Percentage: number
  part5Percentage: number
  part6Percentage: number
  part7Percentage: number
  part1Detail: Part1Detail[]
  part2Detail: Part2Detail[]
  part3Detail: Part3Detail[]
  part4Detail: Part4Detail[]
  part5Detail: Part5Detail[]
  part6Detail: Part6Detail[]
  part7Detail: Part7Detail[]
  cfrDetail: string,
  gradeScore: string
  netScore: number
  part1SumScore: number
  part2SumScore: number
  part3SumScore: number
  part4SumScore: number
  part5SumScore: number
  part6SumScore: number
  part7SumScore: number
}

export interface PersonalLevel {
  plId: string
  tdesc: string
  edesc: string
  companyId: string
}

export interface PmsMasfromEvaluationRoundModel {
  pmsEvaluationRoundId: string
  companyId: string
  tdesc: string
  edesc: string
  apsyear: string
  apsPeriodStart: string
  apsPeriodEnd: string
  jlId: string
  personalLevel: PersonalLevel2[]
  active: number
  statusFrom: StatusFrom
  statusCode: StatusCode
}

export interface PersonalLevel2 {
  plId: string
  tdesc: string
  edesc: string
  companyId: string
}

export interface StatusFrom {
  code: string
  tdesc: string
  edesc: string
}

export interface StatusCode {
  code: string
  tdesc: string
  edesc: string
}

export interface MasfromStatusType {
  code: string
  tdesc: string
  edesc: string
}

export interface Apsassessy {
  employeeId: string
  bossId: string
  prefix?: Prefix
  fname: string
  lname: string
  efname: string
  elname: string
  bu1?: Bu1
  bu2?: Bu2
  bu3: Bu3
  bu4: Bu4
  bu5: Bu5
  position?: Position
  job: Job
  pl: Pl
  status: Status
  time0: Time0
  resignDate: string
  endWorkDate: string
  startDate: string
  thFullName: string
  engFullName: string
}

export interface Prefix {
  prefixId: string
  tdesc: string
  edesc: string
}

export interface Bu1 {
  bu1id: string
  tdesc: string
  edesc: string
  companyId: string
}

export interface Bu2 {
  bu2id: string
  tdesc: string
  edesc: string
  parent: string
  companyId: string
}

export interface Bu3 {
  bu3id: string
  tdesc: string
  edesc: string
  parent: string
  companyId: string
}

export interface Bu4 {
  bu4id: string
  tdesc: string
  edesc: string
  parent: string
  companyId: string
}

export interface Bu5 {
  bu5id: string
  tdesc: string
  edesc: string
  parent: string
  companyId: string
}

export interface Position {
  positionId: string
  tdesc: string
  edesc: string
  consolidate: string
  shortName: string
  companyId: string
}

export interface Job {
  jobCodeId: string
  tdesc: string
  edesc: string
}

export interface Pl {
  plId: string
  tdesc: string
  edesc: string
  companyId: string
}

export interface Status {
  statusCode: string
  statusType: string
  tdesc: string
  edesc: string
}

export interface Time0 {
  time0id: string
  tdesc: string
  edesc: string
  stickTm: string
  hourD: number
}

export interface Apsapprove1 {
  employeeId: string
  bossId: string
  prefix?: Prefix2
  fname: string
  lname: string
  efname: string
  elname: string
  bu1?: Bu12
  bu2?: Bu22
  bu3: Bu32
  bu4: Bu42
  bu5: Bu52
  position?: Position2
  job: Job2
  pl: Pl2
  status: Status2
  time0: Time02
  resignDate: string
  endWorkDate: string
  startDate: string
  thFullName: string
  engFullName: string
}

export interface Prefix2 {
  prefixId: string
  tdesc: string
  edesc: string
}

export interface Bu12 {
  bu1id: string
  tdesc: string
  edesc: string
  companyId: string
}

export interface Bu22 {
  bu2id: string
  tdesc: string
  edesc: string
  parent: string
  companyId: string
}

export interface Bu32 {
  bu3id: string
  tdesc: string
  edesc: string
  parent: string
  companyId: string
}

export interface Bu42 {
  bu4id: string
  tdesc: string
  edesc: string
  parent: string
  companyId: string
}

export interface Bu52 {
  bu5id: string
  tdesc: string
  edesc: string
  parent: string
  companyId: string
}

export interface Position2 {
  positionId: string
  tdesc: string
  edesc: string
  consolidate: string
  shortName: string
  companyId: string
}

export interface Job2 {
  jobCodeId: string
  tdesc: string
  edesc: string
}

export interface Pl2 {
  plId: string
  tdesc: string
  edesc: string
  companyId: string
}

export interface Status2 {
  statusCode: string
  statusType: string
  tdesc: string
  edesc: string
}

export interface Time02 {
  time0id: string
  tdesc: string
  edesc: string
  stickTm: string
  hourD: number
}

export interface Apsapprove2 {
  employeeId: string
  bossId: string
  prefix: Prefix3
  fname: string
  lname: string
  efname: string
  elname: string
  bu1: Bu13
  bu2: Bu23
  bu3: Bu33
  bu4: Bu43
  bu5: Bu53
  position: Position3
  job: Job3
  pl: Pl3
  status: Status3
  time0: Time03
  resignDate: string
  endWorkDate: string
  startDate: string
  thFullName: string
  engFullName: string
}

export interface Prefix3 {
  prefixId: string
  tdesc: string
  edesc: string
}

export interface Bu13 {
  bu1id: string
  tdesc: string
  edesc: string
  companyId: string
}

export interface Bu23 {
  bu2id: string
  tdesc: string
  edesc: string
  parent: string
  companyId: string
}

export interface Bu33 {
  bu3id: string
  tdesc: string
  edesc: string
  parent: string
  companyId: string
}

export interface Bu43 {
  bu4id: string
  tdesc: string
  edesc: string
  parent: string
  companyId: string
}

export interface Bu53 {
  bu5id: string
  tdesc: string
  edesc: string
  parent: string
  companyId: string
}

export interface Position3 {
  positionId: string
  tdesc: string
  edesc: string
  consolidate: string
  shortName: string
  companyId: string
}

export interface Job3 {
  jobCodeId: string
  tdesc: string
  edesc: string
}

export interface Pl3 {
  plId: string
  tdesc: string
  edesc: string
  companyId: string
}

export interface Status3 {
  statusCode: string
  statusType: string
  tdesc: string
  edesc: string
}

export interface Time03 {
  time0id: string
  tdesc: string
  edesc: string
  stickTm: string
  hourD: number
}

export interface Apsapprove3 {
  employeeId: string
  bossId: string
  prefix: Prefix4
  fname: string
  lname: string
  efname: string
  elname: string
  bu1: Bu14
  bu2: Bu24
  bu3: Bu34
  bu4: Bu44
  bu5: Bu54
  position: Position4
  job: Job4
  pl: Pl4
  status: Status4
  time0: Time04
  resignDate: string
  endWorkDate: string
  startDate: string
  thFullName: string
  engFullName: string
}

export interface Prefix4 {
  prefixId: string
  tdesc: string
  edesc: string
}

export interface Bu14 {
  bu1id: string
  tdesc: string
  edesc: string
  companyId: string
}

export interface Bu24 {
  bu2id: string
  tdesc: string
  edesc: string
  parent: string
  companyId: string
}

export interface Bu34 {
  bu3id: string
  tdesc: string
  edesc: string
  parent: string
  companyId: string
}

export interface Bu44 {
  bu4id: string
  tdesc: string
  edesc: string
  parent: string
  companyId: string
}

export interface Bu54 {
  bu5id: string
  tdesc: string
  edesc: string
  parent: string
  companyId: string
}

export interface Position4 {
  positionId: string
  tdesc: string
  edesc: string
  consolidate: string
  shortName: string
  companyId: string
}

export interface Job4 {
  jobCodeId: string
  tdesc: string
  edesc: string
}

export interface Pl4 {
  plId: string
  tdesc: string
  edesc: string
  companyId: string
}

export interface Status4 {
  statusCode: string
  statusType: string
  tdesc: string
  edesc: string
}

export interface Time04 {
  time0id: string
  tdesc: string
  edesc: string
  stickTm: string
  hourD: number
}

export interface Apsapprove4 {
  employeeId: string
  bossId: string
  prefix: Prefix5
  fname: string
  lname: string
  efname: string
  elname: string
  bu1: Bu15
  bu2: Bu25
  bu3: Bu35
  bu4: Bu45
  bu5: Bu55
  position: Position5
  job: Job5
  pl: Pl5
  status: Status5
  time0: Time05
  resignDate: string
  endWorkDate: string
  startDate: string
  thFullName: string
  engFullName: string
}

export interface Prefix5 {
  prefixId: string
  tdesc: string
  edesc: string
}

export interface Bu15 {
  bu1id: string
  tdesc: string
  edesc: string
  companyId: string
}

export interface Bu25 {
  bu2id: string
  tdesc: string
  edesc: string
  parent: string
  companyId: string
}

export interface Bu35 {
  bu3id: string
  tdesc: string
  edesc: string
  parent: string
  companyId: string
}

export interface Bu45 {
  bu4id: string
  tdesc: string
  edesc: string
  parent: string
  companyId: string
}

export interface Bu55 {
  bu5id: string
  tdesc: string
  edesc: string
  parent: string
  companyId: string
}

export interface Position5 {
  positionId: string
  tdesc: string
  edesc: string
  consolidate: string
  shortName: string
  companyId: string
}

export interface Job5 {
  jobCodeId: string
  tdesc: string
  edesc: string
}

export interface Pl5 {
  plId: string
  tdesc: string
  edesc: string
  companyId: string
}

export interface Status5 {
  statusCode: string
  statusType: string
  tdesc: string
  edesc: string
}

export interface Time05 {
  time0id: string
  tdesc: string
  edesc: string
  stickTm: string
  hourD: number
}

export interface Apsapprove5 {
  employeeId: string
  bossId: string
  prefix: Prefix6
  fname: string
  lname: string
  efname: string
  elname: string
  bu1: Bu16
  bu2: Bu26
  bu3: Bu36
  bu4: Bu46
  bu5: Bu56
  position: Position6
  job: Job6
  pl: Pl6
  status: Status6
  time0: Time06
  resignDate: string
  endWorkDate: string
  startDate: string
  thFullName: string
  engFullName: string
}

export interface Prefix6 {
  prefixId: string
  tdesc: string
  edesc: string
}

export interface Bu16 {
  bu1id: string
  tdesc: string
  edesc: string
  companyId: string
}

export interface Bu26 {
  bu2id: string
  tdesc: string
  edesc: string
  parent: string
  companyId: string
}

export interface Bu36 {
  bu3id: string
  tdesc: string
  edesc: string
  parent: string
  companyId: string
}

export interface Bu46 {
  bu4id: string
  tdesc: string
  edesc: string
  parent: string
  companyId: string
}

export interface Bu56 {
  bu5id: string
  tdesc: string
  edesc: string
  parent: string
  companyId: string
}

export interface Position6 {
  positionId: string
  tdesc: string
  edesc: string
  consolidate: string
  shortName: string
  companyId: string
}

export interface Job6 {
  jobCodeId: string
  tdesc: string
  edesc: string
}

export interface Pl6 {
  plId: string
  tdesc: string
  edesc: string
  companyId: string
}

export interface Status6 {
  statusCode: string
  statusType: string
  tdesc: string
  edesc: string
}

export interface Time06 {
  time0id: string
  tdesc: string
  edesc: string
  stickTm: string
  hourD: number
}

export interface Part1Detail {
  companyId: string
  weight: number
  lineNo: number
  scoreTopicExpectation: number
  scoreTopicExpectationBoss: number
  groupAssessment1: GroupAssessment1
}

export interface GroupAssessment1 {
  personalLevelModel: PersonalLevelModel
  companyId: string
  pmsGroupAssessment0: PmsGroupAssessment0
  pmsTopic: PmsTopic2
}

export interface PersonalLevelModel {
  plId: string
  tdesc: string
  edesc: string
  companyId: string
}

export interface PmsGroupAssessment0 {
  personalLevel: PersonalLevel3
  companyId: string
  pmsTopic: PmsTopic
}

export interface PersonalLevel3 {
  plId: string
  tdesc: string
  edesc: string
  companyId: string
}

export interface PmsTopic {
  pmsTopicId: string
  pmsType: PmsType
  companyId: string
  lineNo: number
  edesc: string
  tdesc: string
  indicatorsDetail: string
  performanceGoalsDetail: string
  weight: number
  detailUnit: string
  completionDate: string
  targetAdetail: string
  targetBdetail: string
  targetCdetail: string
  targetDdetail: string
  targetEdetail: string
}

export interface PmsType {
  pmsTypeId: string
  companyId: string
  edesc: string
  tdesc: string
  shortName: string
  weight: number
}

export interface PmsTopic2 {
  pmsTopicId: string
  pmsType: PmsType2
  companyId: string
  lineNo: number
  edesc: string
  tdesc: string
  indicatorsDetail: string
  performanceGoalsDetail: string
  weight: number
  detailUnit: string
  completionDate: string
  targetAdetail: string
  targetBdetail: string
  targetCdetail: string
  targetDdetail: string
  targetEdetail: string
}

export interface PmsType2 {
  pmsTypeId: string
  companyId: string
  edesc: string
  tdesc: string
  shortName: string
  weight: number
}

export interface Part2Detail {
  companyId: string
  weight: number
  lineNo: number
  scoreTopicExpectation: number
  scoreTopicExpectationBoss: number
  groupAssessment1: GroupAssessment12
}

export interface GroupAssessment12 {
  personalLevelModel: PersonalLevelModel2
  companyId: string
  pmsGroupAssessment0: PmsGroupAssessment02
  pmsTopic: PmsTopic4
}

export interface PersonalLevelModel2 {
  plId: string
  tdesc: string
  edesc: string
  companyId: string
}

export interface PmsGroupAssessment02 {
  personalLevel: PersonalLevel4
  companyId: string
  pmsTopic: PmsTopic3
}

export interface PersonalLevel4 {
  plId: string
  tdesc: string
  edesc: string
  companyId: string
}

export interface PmsTopic3 {
  pmsTopicId: string
  pmsType: PmsType3
  companyId: string
  lineNo: number
  edesc: string
  tdesc: string
  indicatorsDetail: string
  performanceGoalsDetail: string
  weight: number
  detailUnit: string
  completionDate: string
  targetAdetail: string
  targetBdetail: string
  targetCdetail: string
  targetDdetail: string
  targetEdetail: string
}

export interface PmsType3 {
  pmsTypeId: string
  companyId: string
  edesc: string
  tdesc: string
  shortName: string
  weight: number
}

export interface PmsTopic4 {
  pmsTopicId: string
  pmsType: PmsType4
  companyId: string
  lineNo: number
  edesc: string
  tdesc: string
  indicatorsDetail: string
  performanceGoalsDetail: string
  weight: number
  detailUnit: string
  completionDate: string
  targetAdetail: string
  targetBdetail: string
  targetCdetail: string
  targetDdetail: string
  targetEdetail: string
}

export interface PmsType4 {
  pmsTypeId: string
  companyId: string
  edesc: string
  tdesc: string
  shortName: string
  weight: number
}

export interface Part3Detail {
  companyId: string
  weight: number
  lineNo: number
  scoreTopicExpectation: number
  scoreTopicExpectationBoss: number
  groupAssessment1: GroupAssessment13
}

export interface GroupAssessment13 {
  personalLevelModel: PersonalLevelModel3
  companyId: string
  pmsGroupAssessment0: PmsGroupAssessment03
  pmsTopic: PmsTopic6
}

export interface PersonalLevelModel3 {
  plId: string
  tdesc: string
  edesc: string
  companyId: string
}

export interface PmsGroupAssessment03 {
  personalLevel: PersonalLevel5
  companyId: string
  pmsTopic: PmsTopic5
}

export interface PersonalLevel5 {
  plId: string
  tdesc: string
  edesc: string
  companyId: string
}

export interface PmsTopic5 {
  pmsTopicId: string
  pmsType: PmsType5
  companyId: string
  lineNo: number
  edesc: string
  tdesc: string
  indicatorsDetail: string
  performanceGoalsDetail: string
  weight: number
  detailUnit: string
  completionDate: string
  targetAdetail: string
  targetBdetail: string
  targetCdetail: string
  targetDdetail: string
  targetEdetail: string
}

export interface PmsType5 {
  pmsTypeId: string
  companyId: string
  edesc: string
  tdesc: string
  shortName: string
  weight: number
}

export interface PmsTopic6 {
  pmsTopicId: string
  pmsType: PmsType6
  companyId: string
  lineNo: number
  edesc: string
  tdesc: string
  indicatorsDetail: string
  performanceGoalsDetail: string
  weight: number
  detailUnit: string
  completionDate: string
  targetAdetail: string
  targetBdetail: string
  targetCdetail: string
  targetDdetail: string
  targetEdetail: string
}

export interface PmsType6 {
  pmsTypeId: string
  companyId: string
  edesc: string
  tdesc: string
  shortName: string
  weight: number
}

export interface Part4Detail {
  plId: string
  companyId: string
  lineNo: number
  competencyType: CompetencyType
  masfromStatusType: MasfromStatusType2
  currentStep: string
  lastStep: string
  checkStep: string
  apsassessyStatus: string
  apsapprove1Status: string
  apsapprove2Status: string
  apsapprove3Status: string
  apsapprove4Status: string
  apsapprove5Status: string
  weightScore1: number
  weightScore2: number
  weightScore3: number
  weightScore4: number
  weightScore5: number
  weightedTotal: number
  averageScore: number
  apsassessyComment: string
  apsapprove1Comment: string
  apsapprove2Comment: string
  apsapprove3Comment: string
  apsapprove4Comment: string
  apsapprove5Comment: string
  apsassessyDate: string
  apsapprove1Date: string
  apsapprove2Date: string
  apsapprove3Date: string
  apsapprove4Date: string
  apsapprove5Date: string
  evaluationResults: string
  sumEvaluationResults: string
}

export interface CompetencyType {
  competencyTypeId: string
  companyId: string
  edesc: string
  tdesc: string
  shortName: string
  expectationLevel: string
  weight: number
}

export interface MasfromStatusType2 {
  code: string
  tdesc: string
  edesc: string
}

export interface Part5Detail {
  pmsWorkingTimeId: string
  tdesc: string
  edesc: string
  weight: number
  detailUnit: string
  performanceTargets: string
  targetADetail: string
  targetBDetail: string
  targetCDetail: string
  targetDDetail: string
  targetEDetail: string
  pmsWorkingTimeScore: number
  pmsWorkingTimeScoreBoss: number
}

export interface Part6Detail {
  companyId: string
  weight: number
  lineNo: number
  scoreTopicExpectation: number
  scoreTopicExpectationBoss: number
  groupAssessment1: GroupAssessment14
}

export interface GroupAssessment14 {
  personalLevelModel: PersonalLevelModel4
  companyId: string
  pmsGroupAssessment0: PmsGroupAssessment04
  pmsTopic: PmsTopic8
}

export interface PersonalLevelModel4 {
  plId: string
  tdesc: string
  edesc: string
  companyId: string
}

export interface PmsGroupAssessment04 {
  personalLevel: PersonalLevel6
  companyId: string
  pmsTopic: PmsTopic7
}

export interface PersonalLevel6 {
  plId: string
  tdesc: string
  edesc: string
  companyId: string
}

export interface PmsTopic7 {
  pmsTopicId: string
  pmsType: PmsType7
  companyId: string
  lineNo: number
  edesc: string
  tdesc: string
  indicatorsDetail: string
  performanceGoalsDetail: string
  weight: number
  detailUnit: string
  completionDate: string
  targetAdetail: string
  targetBdetail: string
  targetCdetail: string
  targetDdetail: string
  targetEdetail: string
}

export interface PmsType7 {
  pmsTypeId: string
  companyId: string
  edesc: string
  tdesc: string
  shortName: string
  weight: number
}

export interface PmsTopic8 {
  pmsTopicId: string
  pmsType: PmsType8
  companyId: string
  lineNo: number
  edesc: string
  tdesc: string
  indicatorsDetail: string
  performanceGoalsDetail: string
  weight: number
  detailUnit: string
  completionDate: string
  targetAdetail: string
  targetBdetail: string
  targetCdetail: string
  targetDdetail: string
  targetEdetail: string
}

export interface PmsType8 {
  pmsTypeId: string
  companyId: string
  edesc: string
  tdesc: string
  shortName: string
  weight: number
}

export interface Part7Detail {
  companyId: string
  weight: number
  lineNo: number
  scoreTopicExpectation: number
  scoreTopicExpectationBoss: number
  groupAssessment1: GroupAssessment15
}

export interface GroupAssessment15 {
  personalLevelModel: PersonalLevelModel5
  companyId: string
  pmsGroupAssessment0: PmsGroupAssessment05
  pmsTopic: PmsTopic10
}

export interface PersonalLevelModel5 {
  plId: string
  tdesc: string
  edesc: string
  companyId: string
}

export interface PmsGroupAssessment05 {
  personalLevel: PersonalLevel7
  companyId: string
  pmsTopic: PmsTopic9
}

export interface PersonalLevel7 {
  plId: string
  tdesc: string
  edesc: string
  companyId: string
}

export interface PmsTopic9 {
  pmsTopicId: string
  pmsType: PmsType9
  companyId: string
  lineNo: number
  edesc: string
  tdesc: string
  indicatorsDetail: string
  performanceGoalsDetail: string
  weight: number
  detailUnit: string
  completionDate: string
  targetAdetail: string
  targetBdetail: string
  targetCdetail: string
  targetDdetail: string
  targetEdetail: string
}

export interface PmsType9 {
  pmsTypeId: string
  companyId: string
  edesc: string
  tdesc: string
  shortName: string
  weight: number
}

export interface PmsTopic10 {
  pmsTopicId: string
  pmsType: PmsType10
  companyId: string
  lineNo: number
  edesc: string
  tdesc: string
  indicatorsDetail: string
  performanceGoalsDetail: string
  weight: number
  detailUnit: string
  completionDate: string
  targetAdetail: string
  targetBdetail: string
  targetCdetail: string
  targetDdetail: string
  targetEdetail: string
}

export interface PmsType10 {
  pmsTypeId: string
  companyId: string
  edesc: string
  tdesc: string
  shortName: string
  weight: number
}