import { ChangeDetectorRef, Component, EventEmitter, Input, Output } from '@angular/core';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { TranslateService } from '@ngx-translate/core';
import { DocumentManagerModel, MyDocumentManagerModel } from 'src/app/shared/model/document-manager.model';
import { DocumentManagerService } from 'src/app/shared/services/documents.service';
import { FileService } from 'src/app/shared/services/file.service';
import Swal from 'sweetalert2';
interface SubModule {
  title: SafeHtml;
  route?: string;
  file?: string;
}

@Component({
  selector: 'app-recruitment-selection',
  templateUrl: './recruitment-selection.component.html',
  styleUrls: ['./recruitment-selection.component.scss']
})
export class RecruitmentSelectionComponent {
  menuList = [
    [{ text: "ตำแหน่งงานว่าง", description: "" },
    { text: "JD ของตำแหน่งงานว่าง", description: "" },
    { text: "Job Specification ของตำแหน่งงานว่าง", description: "" },],
    [{ text: "การเปรียบเทียบคู่ Candidate (Persona)", description: "" },
    { text: "ข้อสอบสรรหา", description: "" },
    { text: "ฐานข้อมูลของผู้สมัคร", description: "" },],
    [{ text: "ตรวจสอบประวัติของ Candidate", description: "" },
    { text: "การแจ้งผล", description: "" },
    { text: "ส่งต่อฐานข้อมูล", description: "" },],
  ];




  documentManager: { loading: boolean, dataList: DocumentManagerModel[] } = { loading: false, dataList: [] }

  constructor(private sanitizer: DomSanitizer,
    private fileService: FileService,
    private cdr: ChangeDetectorRef,
    private translateService: TranslateService,
    private documentManagerService: DocumentManagerService
  ) {

  }

  ngOnInit(): void {
    this.getDocumentManagerList()
  }

  getDocumentManagerList() {
    this.documentManager.loading = true
    this.documentManagerService.getList().subscribe({
      next: response => {
        this.documentManager.dataList = response.map(x => {
          return new MyDocumentManagerModel(x)
        })
        this.documentManager.loading = false
        this.cdr.detectChanges();
      }, error: error => {
        this.documentManager.loading = false
        console.error('Error fetching employee types:', error);
        this.cdr.detectChanges()
      }
    })
  }
  openReport(file: string) {
    const url = 'assets/reports/' + file;
    window.open(url, '_blank');
  }

  downloadFile(fileName: string) {
    this.fileService.downloadFiles(fileName).subscribe({
      next: response => {
        const url = window.URL.createObjectURL(response);
        const a = document.createElement("a");
        a.href = url;
        a.download = fileName;
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        window.URL.revokeObjectURL(url);
        this.cdr.detectChanges()
      }, error: error => {
        this.showAlert(error.message, 'error')
        this.cdr.detectChanges()
      }
    })
  }

  showAlert(text: string, type: 'success' | 'error') {
    Swal.fire({
      icon: type,
      title: 'แจ้งเตือน',
      text: text,
      showCancelButton: false,
      confirmButtonText: 'ยืนยัน',
    })
  }


  translateText(th?: string, en?: string) {
    return this.translateService.getCurrentLang() == 'th' ? (th || '') : (en || '')
  }


}


