import { Component, EventEmitter, Input, Output, OnInit, ChangeDetectorRef } from '@angular/core';
import { ToastrService } from 'ngx-toastr';
import { CompetencyGradeModel, MyCompetencyGradeModel } from 'src/app/shared/model/competency-grades.model';
import { MyPmsGroupGradeModel } from 'src/app/shared/model/pms-group-grade.model';
import { PmsGroupGradeService } from 'src/app/shared/services/pms-group-grade.service';
export interface DataModel {
  check: boolean;
  code: string;
  tdesc: string;
  edesc: string;
  pmsGrade: CompetencyGradeModel[]
}

@Component({
  selector: 'app-pms-group-grade',
  templateUrl: './pms-group-grade.component.html',
  styleUrls: ['./pms-group-grade.component.scss']
})
export class PmsGroupGradeComponent implements OnInit {
  @Output() sendBackTab: EventEmitter<undefined> = new EventEmitter<undefined>();
  @Input() typeTab: 'add' | 'edit' = 'add'
  @Input() dataSelect: DataModel = { check: false, code: '', tdesc: '', edesc: '', pmsGrade: [] }
  @Input() dataList: DataModel[] = [];
  dataOriginal: DataModel = { check: false, code: '', tdesc: '', edesc: '', pmsGrade: [] }
  @Output() sendDataList: EventEmitter<DataModel[]> = new EventEmitter<DataModel[]>();
  currentTab = 1
  constructor(private toastr: ToastrService,
    private pmsGroupGradeService: PmsGroupGradeService,
    private cdr: ChangeDetectorRef) { }
  ngOnInit(): void {
    this.dataOriginal = JSON.parse(JSON.stringify(this.dataSelect || { check: false, code: '', tdesc: '', edesc: '', pmsGrade: [] }))
  }
  clear() {
    if (this.typeTab == 'add') {
      this.dataSelect = { check: false, code: '', tdesc: '', edesc: '', pmsGrade: [] }
      this.cdr.detectChanges()
    } else if (this.typeTab == 'edit') {
      this.dataSelect = { check: false, code: this.dataOriginal.code, tdesc: '', edesc: '', pmsGrade: [] }
      this.cdr.detectChanges()
    }
  }
  backTab() {
    this.sendBackTab.emit();
  }
  postPmsGroupGrade() {
    this.pmsGroupGradeService.post(new MyPmsGroupGradeModel({ groupGradeId: this.dataSelect.code, tdesc: this.dataSelect.tdesc, edesc: this.dataSelect.edesc, pmsGrade: this.dataSelect.pmsGrade })).subscribe({
      next: response => {
        if (response.success) {
          this.showAlert(response.message, 'success')
          this.getPmsGroupGradeList()
        } else {
          this.showAlert(response.message, 'error')
        }
      }, error: error => {
        this.showAlert(error.message, 'error')
      }
    })
  }
  getPmsGroupGradeList() {
    this.pmsGroupGradeService.getList().subscribe({
      next: response => {
        this.sendDataList.emit(response.map(x => ({ check: false, code: x.groupGradeId, tdesc: x.tdesc, edesc: x.edesc, pmsGrade: x.pmsGrade })))
        this.cdr.detectChanges()
      }
    })
  }
  showAlert(text: string, type: 'success' | 'error') {
    this.toastr[type](text, 'แจ้งเตือน', {
      timeOut: 3000,
      positionClass: 'toast-top-right',
    });
  }

  checkPrimary() {
    return this.dataList.find(x => x.code == this.dataSelect.code)
  }

}
