import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { AlertModel } from '../model/alert.model';
import { SettingAssessmentModel } from '../model/setting-assessment.model';

@Injectable({
  providedIn: 'root'
})
export class SettingAssessmentService {
  api = "/setting-assessment"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  get(): Observable<SettingAssessmentModel> {
    return this.http.get<SettingAssessmentModel>(this.urlApi + "")
  }
  // getById(companyId: string): Observable<SettingAssessmentModel> {
  //     return this.http.get<SettingAssessmentModel>(this.urlApi + "/" + companyId)
  // }
  post(body: SettingAssessmentModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi, body)
  }
  delete(body: SettingAssessmentModel | SettingAssessmentModel[]): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi, options)
  }
}
