import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { AlertModel } from '../model/alert.model';
import { PmsWorkingTimeModel } from '../model/pms-working-time.model';

@Injectable({
  providedIn: 'root'
})
export class PmsWorkingTimeService {
  api = "/pms-working-time"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getById(pmsWorkingTimeId: string): Observable<PmsWorkingTimeModel> {
    return this.http.get<PmsWorkingTimeModel>(this.urlApi + "/" + pmsWorkingTimeId)
  }
  getList(): Observable<PmsWorkingTimeModel[]> {
    return this.http.get<PmsWorkingTimeModel[]>(this.urlApi + "/lists")
  }
  post(body: PmsWorkingTimeModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi, body)
  }
  delete(body: PmsWorkingTimeModel[]): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi, options)
  }
}