import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { AlertModel } from '../model/alert.model';
import { PmsEvaluationFactorsModel } from '../model/pms-evaluation-factors.model';

@Injectable({
  providedIn: 'root'
})
export class PmsEvaluationFactorsService {
  api = "/pms-evaluation-factors"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getList(): Observable<PmsEvaluationFactorsModel[]> {
    return this.http.get<PmsEvaluationFactorsModel[]>(this.urlApi + "/lists")
  }
  post(body: PmsEvaluationFactorsModel[]): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi, body)
  }
}