import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { AlertModel } from '../model/alert.model';
import { EvaluationCycleModel } from '../model/evaluation-cycle.model';
import { AppraisalModel } from '../model/appraisal.model';
import { AppraisalRoundModel } from '../model/appraisal-aps.model';
import { EvaluationModal } from '../model/evaluation-form.modal';
import { PmsMasfromEvaluationModel } from '../model/pms-masfrom-evaluation.model';
import { masfromEvaluationAssessment1List, PmsMasfromEvaluationFullModel } from '../model/pms-masfrom-evaluation-list.model';

@Injectable({
  providedIn: 'root'
})
export class PmsEvaluationAssessmentService {
  api = "/pms-evaluation-assessment"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getList(): Observable<EvaluationCycleModel[]> {
    return this.http.get<EvaluationCycleModel[]>(this.urlApi + "/lists")
  }
  getById(evaluationRoundId: string, apsyear: string): Observable<PmsMasfromEvaluationFullModel[]> {
    return this.http.get<PmsMasfromEvaluationFullModel[]>(this.urlApi + "/" + evaluationRoundId + "/" + apsyear)
  }
  getApsassessy(evaluationRoundId: string, apsassessy: string, apsyear: string): Observable<EvaluationModal> {
    return this.http.get<EvaluationModal>(this.urlApi + "/" + evaluationRoundId + "/" + apsassessy + "/" + apsyear)
  }
  getApsassessyMini(evaluationRoundId: string, apsassessy: string, apsyear: string): Observable<masfromEvaluationAssessment1List[]> {
    return this.http.get<masfromEvaluationAssessment1List[]>(this.urlApi + "/mini/" + evaluationRoundId + "/" + apsassessy + "/" + apsyear)
  }
  getIndicators(jobCodeId: string): Observable<masfromEvaluationAssessment1List[]> {
    return this.http.get<masfromEvaluationAssessment1List[]>(this.urlApi + "/pms-topic/list/" + jobCodeId)
  }
  post(body: PmsMasfromEvaluationFullModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi, body)
  }
  postList(body: any): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi + "/create-list", body)
  }
  delete(body: EvaluationCycleModel | EvaluationCycleModel[]): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi, options)
  }

  deletemMini(body: AppraisalRoundModel[], apsassessy: string, evaluationRoundId: string): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi + '/delete-mini' + "/" + apsassessy + "/" + evaluationRoundId, options)
  }
}
