import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { AlertModel } from '../model/alert.model';
import { JobFamilyModel } from '../model/job-family.model';

@Injectable({
    providedIn: 'root'
  })
  export class JobFamilyService {
    api = "/job-family"
    urlApi = environment.baseUrl + this.api
    constructor(private http: HttpClient) {
    }
    getById(positionId:string): Observable<JobFamilyModel> {
      return this.http.get<JobFamilyModel>(this.urlApi  + "/" + positionId)
    }
    getList(): Observable<JobFamilyModel[]> {
      return this.http.get<JobFamilyModel[]>(this.urlApi + "/lists")
    }
    post(body: JobFamilyModel): Observable<AlertModel> {
      return this.http.post<AlertModel>(this.urlApi, body)
    }
    delete(body: JobFamilyModel | JobFamilyModel[]): Observable<AlertModel> {
      const options = {
          headers: new HttpHeaders({
            "Content-Type": "application/json",
          }),
          body: body
        };
      return this.http.delete<AlertModel>(this.urlApi, options)
    }
  }