import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { AlertModel } from '../model/alert.model';
import { GroupAssessmentModel } from '../model/group-assessment.model';
@Injectable({
  providedIn: 'root'
})
export class GroupAssessmentService {
  api = "/groupassessment"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getById(plId: string): Observable<GroupAssessmentModel> {
    return this.http.get<GroupAssessmentModel>(this.urlApi + "/" + plId)
  }
  getList(): Observable<GroupAssessmentModel[]> {
    return this.http.get<GroupAssessmentModel[]>(this.urlApi + "/lists")
  }
  post(body: GroupAssessmentModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi, body)
  }
  delete(body: GroupAssessmentModel | GroupAssessmentModel[]): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi, options)
  }
}