import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Observable } from 'rxjs';
import { TemplateFileModel, TemplateModel } from '../model/template.model';
import { ModuleModel } from '../model/module.model';
import { ExcelPortalModel, ExcelPortalGroupModel, ExcelPortalTagsModel } from '../model/excel-portal.model';
import { AlertModel } from '../model/alert.model';
import { TemplateFileMiniModel } from '../model/template-file-mini.model';
import { environment } from 'src/environments/environment';
@Injectable({
  providedIn: 'root'
})
export class ExcelReportService {

  constructor(private http: HttpClient,
  ) { }
  getExcelList(): Observable<TemplateModel[]> {
    return this.http.get<TemplateModel[]>(environment.portal + "/template/lists?companyid=eb2f4f30-edaf-11ee-a69a-c7680edc0e47")
  }
  getModuleList(): Observable<ModuleModel[]> {
    return this.http.get<ModuleModel[]>(environment.portal + "/template/lists/module?companyid=eb2f4f30-edaf-11ee-a69a-c7680edc0e47")
  }
  getExcelPortalList(): Observable<ExcelPortalModel[]> {
    return this.http.get<ExcelPortalModel[]>(environment.portal + "/excel-center/content/lists")
  }
  getExcelPortalgGroupList(): Observable<ExcelPortalGroupModel[]> {
    return this.http.get<ExcelPortalGroupModel[]>(environment.portal + "/portal-group/lists")
  }
  getExcelPortalTagsList(): Observable<ExcelPortalTagsModel[]> {
    return this.http.get<ExcelPortalTagsModel[]>(environment.portal + "/tag/lists")
  }

  postTemplate(body: {
    templateId: string,
    tname: string,
    ename: string,
    tdesc: string,
    edesc: string,
    module: string
  }) {
    return this.http.post(environment.portal + "/template?companyid=eb2f4f30-edaf-11ee-a69a-c7680edc0e47", body)
  }
  deleteTemplate(body: TemplateModel): Observable<AlertModel> {
    let option = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    }
    return this.http.delete<AlertModel>(environment.portal + "/template?companyid=eb2f4f30-edaf-11ee-a69a-c7680edc0e47", option)
  }
  postTemplateFile(body: TemplateFileModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(environment.portal + "/template-file?companyid=eb2f4f30-edaf-11ee-a69a-c7680edc0e47", body)
  }
  deleteTemplateFile(body: TemplateFileModel): Observable<AlertModel> {
    let option = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    }
    return this.http.delete<AlertModel>(environment.portal + "/template-file?companyid=eb2f4f30-edaf-11ee-a69a-c7680edc0e47", option)
  }
  downloadTemplateFile(fileName: string) {
    return this.http.get(environment.portal + "/template-file/download/excel/" + fileName + "?companyid=eb2f4f30-edaf-11ee-a69a-c7680edc0e47", { responseType: 'blob' })
  }
  printExcelReport(body: {
    fileName: string,
    paramObj: string
  }) {
    return this.http.post(environment.portal + "/template-file/export-to-excel?companyid=eb2f4f30-edaf-11ee-a69a-c7680edc0e47", body, { responseType: 'blob' })
  }
  getTemplateFile(templateid: string, filename: string): Observable<AlertModel> {
    return this.http.get<AlertModel>(environment.portal + "/template-file/" + templateid + "/" + filename + "?companyid=eb2f4f30-edaf-11ee-a69a-c7680edc0e47",)
  }

  getTemplateFileLists(): Observable<TemplateFileMiniModel[]> {
    return this.http.get<TemplateFileMiniModel[]>(environment.portal + "/template-file/menuitem/mini/lists?companyid=eb2f4f30-edaf-11ee-a69a-c7680edc0e47",)
  }
}