import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { StatusModel } from '../model/status.model';

@Injectable({
    providedIn: 'root'
})
export class EmpStatusService {
    api = "/emp-status"
    urlApi = environment.baseUrl + this.api
    constructor(private http: HttpClient) {
    }
    getList(): Observable<StatusModel[]> {
        return this.http.get<StatusModel[]>(this.urlApi + "/lists")
    }
}