import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { CompetencycourseModel } from '../model/competencycourse.model';
import { AlertModel } from '../model/alert.model';
import { CompetencycourseMiniModel } from '../model/competencycourse-mini.model';
@Injectable({
  providedIn: 'root'
})
export class CompetencycourseService {
  api = "/competencycourse"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getById(competencyTypeId: string): Observable<CompetencycourseModel> {
    return this.http.get<CompetencycourseModel>(this.urlApi + "/" + competencyTypeId)
  }
  getList(): Observable<CompetencycourseModel[]> {
    return this.http.get<CompetencycourseModel[]>(this.urlApi + "/lists")
  }
  getMiniList(): Observable<CompetencycourseMiniModel[]> {
    return this.http.get<CompetencycourseMiniModel[]>(this.urlApi + "/mini/lists")
  }
  post(body: CompetencycourseModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi, body)
  }
  delete(body: CompetencycourseModel | CompetencycourseModel[]): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi, options)
  }
}