import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { Bu7Model } from '../model/bu7.model';
import { AlertModel } from '../model/alert.model';
@Injectable({
    providedIn: 'root'
})
export class Bu7Service {
    api = "/bu7"
    urlApi = environment.baseUrl + this.api
    constructor(private http: HttpClient) {
    }
    getList(): Observable<Bu7Model[]> {
        return this.http.get<Bu7Model[]>(this.urlApi + "/lists")
    }
    getListByParent(bu6id: string): Observable<Bu7Model[]> {
        return this.http.get<Bu7Model[]>(environment.baseUrl + "/bu6/parent/" + bu6id)
    }
    getById(bu7id: string): Observable<Bu7Model> {
        return this.http.get<Bu7Model>(environment.baseUrl + "/bu6/" + bu7id)
    }
    post(body: Bu7Model): Observable<AlertModel> {
        return this.http.post<AlertModel>(this.urlApi, body)
    }
    delete(body: Bu7Model[]): Observable<AlertModel> {
        const options = {
            headers: new HttpHeaders({
                "Content-Type": "application/json",
            }),
            body: body
        };
        return this.http.delete<AlertModel>(this.urlApi, options)
    }
}
