import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { Bu6Model } from '../model/bu6.model';
import { AlertModel } from '../model/alert.model';
@Injectable({
    providedIn: 'root'
})
export class Bu6Service {
    api = "/bu6"
    urlApi = environment.baseUrl + this.api
    constructor(private http: HttpClient) {
    }
    getList(): Observable<Bu6Model[]> {
        return this.http.get<Bu6Model[]>(this.urlApi + "/lists")
    }
    getListByParent(bu5id: string): Observable<Bu6Model[]> {
        return this.http.get<Bu6Model[]>(environment.baseUrl + "/bu5/parent/" + bu5id)
    }
    getById(bu6id: string): Observable<Bu6Model> {
        return this.http.get<Bu6Model>(this.urlApi + "/" + bu6id)
    }
    post(body: Bu6Model): Observable<AlertModel> {
        return this.http.post<AlertModel>(this.urlApi, body)
    }
    delete(body: Bu6Model[]): Observable<AlertModel> {
        const options = {
            headers: new HttpHeaders({
                "Content-Type": "application/json",
            }),
            body: body
        };
        return this.http.delete<AlertModel>(this.urlApi, options)
    }
}
