import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { Bu3Model } from '../model/bu3.model';
import { AlertModel } from '../model/alert.model';
@Injectable({
  providedIn: 'root'
})
export class Bu3Service {
  api = "/bu3"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getById(bu3id: string): Observable<Bu3Model> {
    return this.http.get<Bu3Model>(this.urlApi + "/" + bu3id)
  }
  getListByParent(bu2id: string): Observable<Bu3Model[]> {
    return this.http.get<Bu3Model[]>(environment.baseUrl + "/bu2/parent/" + bu2id)
  }
  getList(): Observable<Bu3Model[]> {
    return this.http.get<Bu3Model[]>(this.urlApi + "/lists")
  }
  post(body: Bu3Model): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi, body)
  }
  delete(body: Bu3Model[]): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi, options)
  }
}