import { MyPageableModel, PageableModel } from "./pageable.model"
import { MySortModel, SortModel } from "./sort.model"

export interface PageModel {
    content: any
    pageable: PageableModel
    totalElements: number
    totalPages: number
    last: boolean
    size: number
    number: number
    sort: SortModel
    numberOfElements: number
    first: boolean
    empty: boolean
}

export class MyPageModel implements PageModel {
    content: any
    pageable: PageableModel
    totalElements: number
    totalPages: number
    last: boolean
    size: number
    number: number
    sort: SortModel
    numberOfElements: number
    first: boolean
    empty: boolean
    constructor(data: Partial<PageModel>) {
        this.content = data.content
        this.pageable = new MyPageableModel(data.pageable || {})
        this.totalElements = data.totalElements ?? 0
        this.totalPages = data.totalPages ?? 0
        this.last = data.last || false
        this.size = data.size ?? 0
        this.number = data.number ?? 0
        this.sort = new MySortModel(data.sort || {})
        this.numberOfElements = data.numberOfElements ?? 0
        this.first = data.first || false
        this.empty = data.empty || false
    }
}

