export interface AppraisalRoundModel {
    runNo: number;
    companyId: string;
    groupAssessment1: GroupAssessment1;
  }
  
  export interface GroupAssessment1 {
    personalLevelModel: PersonalLevelModel;
    competencyIndicatorsCourses1Mini: CompetencyIndicatorsCourses1Mini;
    companyId: string;
    groupAssessmentMini: GroupAssessmentMini;
  }
  
  export interface PersonalLevelModel {
    plId: string;
    tdesc: any;
    edesc: any;
    companyId: any;
  }
  
  export interface CompetencyIndicatorsCourses1Mini {
    competencyIndicatorsCourses0: CompetencyIndicatorsCourses0;
    lineNo: number;
    companyId: string;
    competencyCourseId: string;
    behavioralIndicatorsList: BehavioralIndicatorsList[];
  }
  
  export interface CompetencyIndicatorsCourses0 {
    competencyTopic: CompetencyTopic;
    companyId: string;
    edesc: string;
    tdesc: string;
    indicatorsCourseDetailTh: string;
    indicatorsCourseDetailEn: string;
    expectation: any;
  }
  
  export interface CompetencyTopic {
    competencyTopicId: string;
    competencyType: any;
    companyId: any;
    edesc: any;
    tdesc: any;
    competencyDetail: any;
    competencyFiles: any;
    lineNo: any;
  }
  
  export interface BehavioralIndicatorsList {
    competencyIndicators1: CompetencyIndicators1;
    runNo: number;
    companyId: string;
    assessmentId: string;
    behavioralIndicators: string;
    competencyBehavioral: CompetencyBehavioral;
  }
  
  export interface CompetencyIndicators1 {
    competencyIndicatorsCourses0: CompetencyIndicatorsCourses02;
    lineNo: number;
    companyId: string;
    competencyCourseId: string;
  }
  
  export interface CompetencyIndicatorsCourses02 {
    competencyTopic: CompetencyTopic;
    companyId: string;
    edesc: string;
    tdesc: string;
    indicatorsCourseDetailTh: string;
    indicatorsCourseDetailEn: string;
  }
  
  
  export interface CompetencyBehavioral {
    scoreTopicExpectation: number;
    companyId: string;
  }
  
  export interface GroupAssessmentMini {
    personalLevel: PersonalLevel;
    competencyIndicatorsCourses1Mini: any;
    companyId: string;
    edesc: any;
    tdesc: any;
  }
  
  export interface PersonalLevel {
    plId: string;
    tdesc: any;
    edesc: any;
    companyId: any;
  }
  
  // ------------------------- Class Implementation -------------------------
  
  export class MyAppraisalRoundModel implements AppraisalRoundModel {
    runNo: number;
    companyId: string;
    groupAssessment1: GroupAssessment1;
  
    constructor(data?: Partial<AppraisalRoundModel>) {
      this.runNo = data?.runNo ?? 0;
      this.companyId = data?.companyId || "";
      this.groupAssessment1 = new MyGroupAssessment1(data?.groupAssessment1);
    }
  }
  
  export class MyGroupAssessment1 implements GroupAssessment1 {
    personalLevelModel: PersonalLevelModel;
    competencyIndicatorsCourses1Mini: CompetencyIndicatorsCourses1Mini;
    companyId: string;
    groupAssessmentMini: GroupAssessmentMini;
  
    constructor(data?: Partial<GroupAssessment1>) {
      this.personalLevelModel = new MyPersonalLevelModel(data?.personalLevelModel);
      this.competencyIndicatorsCourses1Mini = new MyCompetencyIndicatorsCourses1Mini(data?.competencyIndicatorsCourses1Mini);
      this.companyId = data?.companyId || "";
      this.groupAssessmentMini = new MyGroupAssessmentMini(data?.groupAssessmentMini);
    }
  }
  
  export class MyPersonalLevelModel implements PersonalLevelModel {
    plId: string;
    tdesc: any;
    edesc: any;
    companyId: any;
  
    constructor(data?: Partial<PersonalLevelModel>) {
      this.plId = data?.plId || "";
      this.tdesc = data?.tdesc ?? null;
      this.edesc = data?.edesc ?? null;
      this.companyId = data?.companyId ?? null;
    }
  }
  
  export class MyCompetencyIndicatorsCourses1Mini implements CompetencyIndicatorsCourses1Mini {
    competencyIndicatorsCourses0: CompetencyIndicatorsCourses0;
    lineNo: number;
    companyId: string;
    competencyCourseId: string;
    behavioralIndicatorsList: BehavioralIndicatorsList[];
  
    constructor(data?: Partial<CompetencyIndicatorsCourses1Mini>) {
      this.competencyIndicatorsCourses0 = new MyCompetencyIndicatorsCourses0(data?.competencyIndicatorsCourses0);
      this.lineNo = data?.lineNo ?? 0;
      this.companyId = data?.companyId || "";
      this.competencyCourseId = data?.competencyCourseId || "";
      this.behavioralIndicatorsList = data?.behavioralIndicatorsList?.map(item => new MyBehavioralIndicatorsList(item)) || [];
    }
  }
  
  export class MyCompetencyIndicatorsCourses0 implements CompetencyIndicatorsCourses0 {
    competencyTopic: CompetencyTopic;
    companyId: string;
    edesc: string;
    tdesc: string;
    indicatorsCourseDetailTh: string;
    indicatorsCourseDetailEn: string;
    expectation: any;
  
    constructor(data?: Partial<CompetencyIndicatorsCourses0>) {
      this.competencyTopic = new CompetencyTopicModel(data?.competencyTopic);
      this.companyId = data?.companyId || "";
      this.edesc = data?.edesc || "";
      this.tdesc = data?.tdesc || "";
      this.indicatorsCourseDetailTh = data?.indicatorsCourseDetailTh || "";
      this.indicatorsCourseDetailEn = data?.indicatorsCourseDetailEn || "";
      this.expectation = data?.expectation ?? null;
    }
  }
  
  export class MyBehavioralIndicatorsList implements BehavioralIndicatorsList {
    competencyIndicators1: CompetencyIndicators1;
    runNo: number;
    companyId: string;
    assessmentId: string;
    behavioralIndicators: string;
    competencyBehavioral: CompetencyBehavioral;
  
    constructor(data?: Partial<BehavioralIndicatorsList>) {
      this.competencyIndicators1 = new MyCompetencyIndicators1(data?.competencyIndicators1);
      this.runNo = data?.runNo ?? 0;
      this.companyId = data?.companyId || "";
      this.assessmentId = data?.assessmentId || "";
      this.behavioralIndicators = data?.behavioralIndicators || "";
      this.competencyBehavioral = new MyCompetencyBehavioral(data?.competencyBehavioral);
    }
  }
  
  export class MyCompetencyIndicators1 implements CompetencyIndicators1 {
    competencyIndicatorsCourses0: CompetencyIndicatorsCourses02;
    lineNo: number;
    companyId: string;
    competencyCourseId: string;
  
    constructor(data?: Partial<CompetencyIndicators1>) {
      this.competencyIndicatorsCourses0 = new MyCompetencyIndicatorsCourses0(data?.competencyIndicatorsCourses0);
      this.lineNo = data?.lineNo ?? 0;
      this.companyId = data?.companyId || "";
      this.competencyCourseId = data?.competencyCourseId || "";
    }
  }
  
  export class MyCompetencyBehavioral implements CompetencyBehavioral {
    scoreTopicExpectation: number;
    companyId: string;
  
    constructor(data?: Partial<CompetencyBehavioral>) {
      this.scoreTopicExpectation = data?.scoreTopicExpectation ?? 0;
      this.companyId = data?.companyId || "";
    }
  }
  
  export class MyGroupAssessmentMini implements GroupAssessmentMini {
    personalLevel: PersonalLevel;
    competencyIndicatorsCourses1Mini: any;
    companyId: string;
    edesc: any;
    tdesc: any;
  
    constructor(data?: Partial<GroupAssessmentMini>) {
      this.personalLevel = new MyPersonalLevel(data?.personalLevel);
      this.competencyIndicatorsCourses1Mini = data?.competencyIndicatorsCourses1Mini ?? null;
      this.companyId = data?.companyId || "";
      this.edesc = data?.edesc ?? null;
      this.tdesc = data?.tdesc ?? null;
    }
  }
  
  export class MyPersonalLevel implements PersonalLevel {
    plId: string;
    tdesc: any;
    edesc: any;
    companyId: any;
  
    constructor(data?: Partial<PersonalLevel>) {
      this.plId = data?.plId || "";
      this.tdesc = data?.tdesc ?? null;
      this.edesc = data?.edesc ?? null;
      this.companyId = data?.companyId ?? null;
    }
  }
  export class CompetencyTopicModel implements CompetencyTopic {
    competencyTopicId: string;
    competencyType: any;
    companyId: any;
    edesc: any;
    tdesc: any;
    competencyDetail: any;
    competencyFiles: any;
    lineNo: any;

    constructor(data: Partial<CompetencyTopic> = {}) {
        this.competencyTopicId = data.competencyTopicId || "";
        this.competencyType = data.competencyType ?? null;
        this.companyId = data.companyId ?? null;
        this.edesc = data.edesc ?? null;
        this.tdesc = data.tdesc ?? null;
        this.competencyDetail = data.competencyDetail ?? null;
        this.competencyFiles = data.competencyFiles ?? null;
        this.lineNo = data.lineNo ?? null;
    }
}