import { ChangeDetectorRef, Component, EventEmitter, Input, Output } from '@angular/core';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { TranslateService } from '@ngx-translate/core';
import { DocumentManagerModel, MyDocumentManagerModel } from 'src/app/shared/model/document-manager.model';
import { DocumentManagerService } from 'src/app/shared/services/documents.service';
import { FileService } from 'src/app/shared/services/file.service';
import Swal from 'sweetalert2';
import { PmsWorkingTimeService } from 'src/app/shared/services/pms-working-time.service';
import { MyPmsWorkingTimeModel, PmsWorkingTimeModel } from 'src/app/shared/model/pms-working-time.model';
interface SubModule {
  title: SafeHtml;
  route?: string;
  file?: string;
}

@Component({
  selector: 'app-time-attendance-wizard',
  templateUrl: './time-attendance-wizard.component.html',
  styleUrls: ['./time-attendance-wizard.component.scss']
})
export class TimeAttendanceWizardComponent {
  pmsWorkingTime: { loading: boolean, select: PmsWorkingTimeModel, dataList: PmsWorkingTimeModel[] } = { loading: false, select: new MyPmsWorkingTimeModel(), dataList: [] }

  constructor(private pmsWorkingTimeService: PmsWorkingTimeService,
    private cdr: ChangeDetectorRef,
    private translateService: TranslateService
  ) {

  }

  ngOnInit(): void {
    this.getPmsWorkingTimeList()
  }
  getPmsWorkingTimeList() {
    this.pmsWorkingTime.loading = true
    this.pmsWorkingTimeService.getList().subscribe({
      next: response => {
        this.pmsWorkingTime.dataList = response.map(x => {
          return new MyPmsWorkingTimeModel(x)
        })
        this.cdr.detectChanges();
      }, error: error => {
        this.pmsWorkingTime.loading = false
        this.cdr.detectChanges()
      }
    })
  }

  translateText(th?: string, en?: string) {
    return this.translateService.getCurrentLang() == 'th' ? (th || '') : (en || '')
  }


}