import { ChangeDetectorRef, Component, OnInit, TemplateRef, ViewChild } from '@angular/core';
import { AppraisalCompentencyModel } from 'src/app/shared/model/appraisal-competency.model';
import { AppraisalPmsModel } from 'src/app/shared/model/appraisal-pms.model';
import { TypeList } from 'src/app/shared/model/appraisal-subordinate.model';
import { EmployeeModel, MyEmployeeModel } from 'src/app/shared/model/employee.model';
import { AppraisalService } from 'src/app/shared/services/appraisal.service';
import { EmployeeService } from 'src/app/shared/services/employee.service';
export interface BiModel {
  name: string,
  tools: string[],
  degree: string
}

@Component({
  selector: 'app-self-evaluation',
  templateUrl: './self-evaluation.component.html',
  styleUrls: ['./self-evaluation.component.scss']
})
export class SelfEvaluationComponent implements OnInit {
  pathTitle = ['การประเมินผล', 'ประเมินตนเอง']
  hoveredCode: string | null = null;
  checkSheet: {
    score: string[],
    condition: string[]
  }[] = [{
    score: ["หากได้คะแนน 90 - 100% ถือว่า Gap +1", "หากได้คะแนน 80 - 89% ถือว่า ไม่มี Gap", "หากได้คะแนน 60 - 79% ถือว่า Gap - 1", "หากได้คะแนน 40 - 59% ถือว่า Gap -2", "หากได้คะแนน 0 - 39% ถือว่า Gap - 3"],
    condition: ["1.หากได้คะแนนสูงกว่า 80% แต่มี 3 2 หรือ 1 ด้วย ถือว่า Gap -1", "2.หากได้คะแนนต่ำกว่า 80% แต่มี 4 และ 5 ให้คิด Gap ตาม %", "3.คะแนนต่ำกว่า 80% แต่มี 2 และ 1 ให้คิด Gap ตาม %"],
  }]
  appraisalCompentency: { loading: boolean, select?: AppraisalCompentencyModel, dataList: AppraisalCompentencyModel[] } = { loading: false, select: undefined, dataList: [] }
  appraisalPms: { loading: boolean, select?: AppraisalPmsModel, dataList: { check: boolean, data: AppraisalPmsModel }[] } = { loading: false, select: undefined, dataList: [] }
  evaluatee: { loading: boolean, data: EmployeeModel } = { loading: false, data: new MyEmployeeModel() }
  currentDate = new Date()
  competencyTypeId = ""

  onEdit = ''

  allCompetencyTypeId = <TypeList[]>[]
  constructor(private appraisalService: AppraisalService,
    private employeeService: EmployeeService,
    private cdr: ChangeDetectorRef
  ) { }
  ngOnInit(): void {
    this.getEvaluatee()
    this.getAppraisalCompentencyList()
    this.getAppraisalPmsList()
  }
  getEvaluatee() {
    this.evaluatee.loading = true
    this.employeeService.getWorking().subscribe({
      next: response => {
        this.evaluatee.data = new MyEmployeeModel(response)
        this.evaluatee.loading = false
        this.cdr.detectChanges()
      }, error: error => {
        this.evaluatee.loading = false
        this.cdr.detectChanges()
      }
    })
  }

  getAppraisalPmsList() {
    this.appraisalPms.loading = true
    this.appraisalService.getPmsList().subscribe({
      next: response => {
        this.appraisalPms.dataList = response.map(x => ({ check: false, data: x }))
        this.appraisalPms.loading = false
        this.cdr.detectChanges()
      }, error: error => {
        this.appraisalPms.loading = false
        this.cdr.detectChanges()
      }
    })
  }
  appraisalPmsFilter(evaluationRoundId: string) {
    return this.appraisalPms.dataList.find(x => x.data.pmsMasfromEvaluationRound.pmsEvaluationRoundId == evaluationRoundId) || { check: false, data: undefined }
  }
  selectAppraisalPms(data?: AppraisalPmsModel) {
    this.appraisalPms.select = JSON.parse(JSON.stringify(data || {}))
  }


  getAppraisalCompentencyList() {
    this.appraisalCompentency.loading = true
    this.appraisalService.getCompetencyList().subscribe({
      next: response => {
        this.appraisalCompentency.dataList = JSON.parse(JSON.stringify(response))
        if (this.appraisalCompentency.dataList.length) {
          this.allCompetencyTypeId = this.appraisalCompentency.dataList[0].masfromEvaluationAssessment1.map(x => ({
            statusType: "",
            competencyTypeId: x.competencyType.competencyTypeId,
            shortName: x.competencyType.shortName,
            averageScore: x.averageScore + ''
          }))
          this.selectAppraisalCompentency(this.appraisalCompentency.dataList[0])
        }
        this.appraisalCompentency.loading = false
        this.cdr.detectChanges()
      }, error: error => {
        this.appraisalCompentency.loading = false
        this.cdr.detectChanges()
      }
    })
  }
  appraisalCompentencyFilter(index: number) {
    return this.appraisalCompentency.dataList[index].masfromEvaluationAssessment1
  }
  selectAppraisalCompentency(data: AppraisalCompentencyModel) {
    this.appraisalCompentency.select = JSON.parse(JSON.stringify(data))
  }
  selectCompentencyForm(typeId: string) {
    this.competencyTypeId = typeId
  }

  showTools(data: string[]) {
    return data.join("/")
  }

  convertDate(dateInput?: string | Date): string {
    let date = new Date()
    if (dateInput) {
      if (typeof dateInput === 'string') {
        const [year, month, day] = dateInput.split('-').map(Number);
        date = new Date(year, month - 1, day);
      } else {
        date = dateInput
      }
    }
    return date?.toLocaleDateString('th-TH', { day: 'numeric', month: 'long', year: 'numeric' }) || ''
  }
}
