import { Component, OnInit } from '@angular/core';
import { EChartsOption } from 'echarts';

interface KpiCard {
  label: string;
  value: number;
  change: number;
  icon: string;
  color: string;       // ใช้ไฮไลต์พื้นหลัง
}

/* ---------- ข้อมูลตารางจำลอง ---------- */
interface PendingEval {
  employee: string;
  evaluator: string;
  round: string;
  department: string;
}
interface TopScore {
  employee: string;
  score: number;
  grade: string;
  round: string;
  evaluator: string;
}

@Component({
  selector: 'app-dashboard-evaluation',
  templateUrl: './dashboard-evaluation.component.html',
  styleUrls: ['./dashboard-evaluation.component.scss']
})
export class DashboardEvaluationComponent implements OnInit {

  /* ========== KPI Cards (mock) ========== */
  kpiCards = [
    {
      label: 'ประเมินเสร็จสิ้น', value: 1293, change: 1.35,
      icon: 'ti ti-layout-grid', bg: 'linear-gradient(135deg,#2563eb,#1d4ed8)'
    },

    {
      label: 'กำลังประเมิน', value: 853, change: 0.82,
      icon: 'ti ti-clipboard-check', bg: 'linear-gradient(135deg,#0ea5e9,#0284c7)'
    },

    {
      label: 'ยังไม่ประเมิน', value: 625, change: -1.12,
      icon: 'ti ti-clock', bg: 'linear-gradient(135deg,#9333ea,#7e22ce)'
    },

    {
      label: 'ผลต่ำสุด', value: 4, change: 2.78,
      icon: 'ti ti-arrow-big-down-line', bg: 'linear-gradient(135deg,#ef4444,#b91c1c)'
    },

    {
      label: 'ผลสูงสุด', value: 12, change: 12.05,
      icon: 'ti ti-arrow-big-up-line', bg: 'linear-gradient(135deg,#22c55e,#15803d)'
    }
  ];

  /* ========== Chart Options (mock) ========== */
  deptScoreOption!: EChartsOption;
  summaryDonutOption!: EChartsOption;
  yearlyCompareOption!: EChartsOption;
  levelDistOption!: EChartsOption;

  /* ========== Table Data (mock) ========== */
  pendingList: PendingEval[] = [
    { employee: 'น.ส. บุญใจ บุญโต', evaluator: 'นาย สุริชัย จินโต', round: '2024/2', department: 'ฝ่ายผลิต' },
    { employee: 'นาย อาทิตย์ รุ่งเรือง', evaluator: 'นาง ภัทธิดา วงศ์ดาว', round: '2024/2', department: 'การตลาด' },
    { employee: 'น.ส. เยาวเรศ พิทักษ์', evaluator: 'นาย พลชัย อธิชาติ', round: '2024/2', department: 'ทรัพยากรบุคคล' }
  ];
  topScoreList: TopScore[] = [
    { employee: 'นาย ชัยยศ สุวรรณ', score: 99, grade: 'A', round: '1/2025', evaluator: 'นาย สุริชัย จินโต' },
    { employee: 'น.ส. อรอนงค์ พรรณา', score: 98, grade: 'A', round: '1/2025', evaluator: 'นาง ภัทธิดา วงศ์ดาว' },
    { employee: 'น.ส. ใจบุญ พิทักษ์', score: 98, grade: 'A', round: '1/2025', evaluator: 'นาย สุริชัย จินโต' },
    { employee: 'นาย อังคาร เรืองรุ่ง', score: 97, grade: 'A', round: '1/2025', evaluator: 'นาง ภัทธิดา วงศ์ดาว' },
    { employee: 'น.ส. เยาวเรศ โตบุญ', score: 96, grade: 'A', round: '1/2025', evaluator: 'นาย พลชัย อธิชาติ' }
  ];

  ngOnInit(): void {
    this.initCharts();
  }

  /* ---------- กำหนดกราฟ ---------- */
  private initCharts(): void {

    /* 1. Bar: คะแนนตามแผนก */
    this.deptScoreOption = {
      toolbox: { show: true, feature: { saveAsImage: { title: 'PNG' } } },
      tooltip: { trigger: 'axis' },
      grid: { top: 20, left: 90, right: 20, bottom: 40 },
      xAxis: {
        type: 'category',
        data: [
          'ทรัพยากรบุคคล', 'การเงิน/บัญชี', 'การตลาด',
          'ฝ่ายขาย', 'ไอที', 'ฝ่ายผลิต', 'ลูกค้าสัมพันธ์'
        ],
        axisLabel: { rotate: 25, color: '#6B7280' }
      },
      yAxis: { type: 'value', name: 'คะแนน', nameTextStyle: { fontWeight: 600 } },
      series: [{
        name: 'คะแนนเฉลี่ย',
        type: 'bar',
        data: [88, 91, 79, 81, 83, 80, 93],
        barWidth: '55%',
        itemStyle: { color: '#3b82f6', borderRadius: [6, 6, 0, 0] },
        label: { show: true, position: 'top' }
      }]
    };
    this.deptScoreOption = {
      toolbox: { show: true, feature: { saveAsImage: { title: 'PNG' } } },
      tooltip: { trigger: 'axis' },
      grid: { top: 20, left: 90, right: 20, bottom: 40 },
      xAxis: {
        type: 'category',
        data: [
          'ทรัพยากรบุคคล', 'การเงิน/บัญชี', 'การตลาด',
          'ฝ่ายขาย', 'ไอที', 'ฝ่ายผลิต', 'ลูกค้าสัมพันธ์'
        ],
        axisLabel: { rotate: 25, color: '#6B7280' }
      },
      yAxis: { type: 'value', nameTextStyle: { fontWeight: 600 } },
      series: [{
        name: 'คะแนนเฉลี่ย',
        type: 'bar',
        barWidth: '55%',
        label: { show: true, position: 'top' },
        data: [
          {
            value: 88,
            itemStyle: {
              color: '#00CFE8',              // สีของ "ทรัพยากรบุคคล"
              borderRadius: [6, 6, 0, 0],
            },
          },
          {
            value: 91,
            itemStyle: {
              color: '#00D2FF',              // สีของ "การเงิน/บัญชี"
              borderRadius: [6, 6, 0, 0],
            },
          },
          {
            value: 79,
            itemStyle: {
              color: '#5A9CFF',              // การตลาด
              borderRadius: [6, 6, 0, 0],
            },
          },
          {
            value: 81,
            itemStyle: {
              color: '#7B7BFF',              // ฝ่ายขาย
              borderRadius: [6, 6, 0, 0],
            },
          },
          {
            value: 83,
            itemStyle: {
              color: '#A05BDB',              // ไอที
              borderRadius: [6, 6, 0, 0],
            },
          },
          {
            value: 80,
            itemStyle: {
              color: '#C218A4',              // ฝ่ายผลิต
              borderRadius: [6, 6, 0, 0],
            },
          },
          {
            value: 93,
            itemStyle: {
              color: '#D4004D',              // ลูกค้าสัมพันธ์
              borderRadius: [6, 6, 0, 0],
            },
          },
        ]
      }]
    };

    /* 2. Donut: ผ่าน/ไม่ผ่าน */
    // this.summaryDonutOption = {
    //   tooltip: { trigger: 'item', formatter: '{b}: {c} ({d}%)' },
    //   legend: { bottom: 0 },
    //   series: [{
    //     type: 'pie',
    //     radius: ['55%', '80%'],
    //     data: [
    //       { value: 87, name: 'ผ่าน', itemStyle: { color: '#10b981' } },
    //       { value: 13, name: 'ไม่ผ่าน', itemStyle: { color: '#ef4444' } }
    //     ],
    //     label: { show: false },
    //     labelLine: { show: false }
    //   }]
    // };
      this.summaryDonutOption = {
        tooltip: {
          trigger: 'item',
          formatter: '{b}: {c} ({d}%)'
        },
        legend: {
          bottom: 0
        },
        series: [
          {
            type: 'pie',
            radius: ['55%', '80%'],
            data: [
              {
                value: 87,
                name: 'ผ่าน',
                itemStyle: { color: '#34bdeb' }
              },
              {
                value: 13,
                name: 'ไม่ผ่าน',
                itemStyle: { color: '#9af0f5' }
              }
            ],
            label: {
              show: false
            },
            labelLine: {
              show: false
            }
          }
        ]
      };

    /* 3. Column: เปรียบเทียบปี */
    this.yearlyCompareOption = {
      tooltip: { trigger: 'axis', axisPointer: { type: 'shadow' } },
      legend: { top: 0 },
      grid: { top: 40, left: 20, right: 20, bottom: 20 },
      xAxis: { type: 'category', data: ['คะแนนรวม'] },
      yAxis: { type: 'value' },
      series: [
        { name: '2024', type: 'bar', data: [79], itemStyle: { color: '#9af0f5', borderRadius: 4 } },
        { name: '2025', type: 'bar', data: [88], itemStyle: { color: '#34bdeb', borderRadius: 4 } }
      ]
    };

    /* 4. Stacked Horizontal Bar: การกระจายเกรด */
    this.levelDistOption = {
      tooltip: { trigger: 'axis', axisPointer: { type: 'shadow' } },
      legend: { top: 0 },
      grid: { top: 40, left: 10, right: 10, bottom: 20 },
      xAxis: { type: 'value' },
      yAxis: { type: 'category', data: [''] },
      series: [
        { name: 'A', type: 'bar', stack: 'total', data: [50], itemStyle: { color: '#2B547E' } },
        { name: 'B', type: 'bar', stack: 'total', data: [40], itemStyle: { color: '#9af0f5' } },
        { name: 'C', type: 'bar', stack: 'total', data: [30], itemStyle: { color: '#34bdeb' } },
        { name: 'D', type: 'bar', stack: 'total', data: [10], itemStyle: { color: '#3090C7' } },
        { name: 'E', type: 'bar', stack: 'total', data: [5], itemStyle: { color: '#659EC7' } }
      ]
    };
  }

  trackByLabel = (_: number, i: KpiCard) => i.label;
}
