import { ChangeDetectorRef, Component, EventEmitter, Input, OnInit, Output, ViewChild } from '@angular/core';
import { MatDialog } from '@angular/material/dialog';
import { ColumnModel } from '@syncfusion/ej2-grids';
import { ToastrService } from 'ngx-toastr';
import { JobFamilyModel, MyJobFamilyModel } from 'src/app/shared/model/job-family.model';
import { FileService } from 'src/app/shared/services/file.service';
import { JobFamilyService } from 'src/app/shared/services/job-family.service';
import Swal from 'sweetalert2';
@Component({
  selector: 'app-job-family',
  templateUrl: './job-family.component.html',
  styleUrls: ['./job-family.component.scss']
})
export class JobFamilyComponent implements OnInit {
  selectedFile: File | null = null;
  selectedFileName: string = 'selectedFileName';
  currentModal: 'add' | 'edit' | 'delete' = 'add'
  jobFamily: { loading: boolean, select: JobFamilyModel, dataList: JobFamilyModel[] } = { loading: false, select: new MyJobFamilyModel(), dataList: [] }

  columns: ColumnModel[] = [{
    field: "jobFamilyId",
    headerText: "JobFamilyCode",
    type: "string",
    isPrimaryKey: true,
  },
  {
    field: "tdesc",
    headerText: "JobFamilyNameThai",
    type: "string"
  },
  {
    field: "edesc",
    headerText: "JobFamilyNameEng",
    type: "string"
  }]
  searchSettings = {
    fields: ['jobFamilyId', 'tdesc', 'edesc'],
    operator: 'contains',
    ignoreCase: false
  };
  search = ''
  selectedItems: { key: string, count: number, data: Map<string, boolean> } = { key: '', count: 0, data: new Map<string, boolean>() };
  @ViewChild("jobFamilyModal") jobFamilyModal: any;
  dialogRef: any

  selectedImg: File | null = null;
  imgLoading = false
  constructor(private jobFamilyService: JobFamilyService,
    private toastr: ToastrService,
    private cdr: ChangeDetectorRef,
    private fileService: FileService,
    private dialog: MatDialog
  ) { }
  ngOnInit(): void {
    this.getJobFamilyList()
  }
  openDialog() {
    this.dialogRef = this.dialog.open(this.jobFamilyModal, {
      width: '500px',
    })
  }
  closeDialog() {
    this.dialogRef.close()
  }


  onFileSelected(event: any) {
    this.selectedFile = event.target.files.length > 0 ? event.target.files[0] : null;
    this.selectedFileName = this.selectedFile?.name || "selectedFileName"
  }

  uploadFile() {
    if (!this.selectedFile) {
      alert('กรุณาเลือกไฟล์ก่อนอัปโหลด')
      return
    }
    const formData = new FormData();
    formData.append('file', this.selectedFile);
    this.jobFamily.loading = true
    this.fileService.uploadExcel(formData, 'MJOB_FAMILY').subscribe({
      next: response => {
        if (response.success) {
          this.showAlert(response.message, 'success')
          this.getJobFamilyList()
        } else {
          this.showAlert(response.message, 'error')
          this.jobFamily.loading = false
          this.cdr.markForCheck();
        }
      }, error: error => {
        this.showAlert(error.message, 'error')
        this.jobFamily.loading = false
        this.cdr.markForCheck();
      }
    })
  }

  downloadFile() {
    const fileName = 'IMPORT_MJOB_FAMILY.xlsx'
    this.fileService.downloadTemplate(fileName).subscribe({
      next: response => {
        const url = window.URL.createObjectURL(response);
        const a = document.createElement("a");
        a.href = url;
        a.download = fileName;
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        window.URL.revokeObjectURL(url);
      }, error: error => {
        this.showAlert(error.message, 'error')
      }
    })
  }
  getJobFamilyList() {
    this.jobFamily.loading = true
    this.selectedItems.data.clear()
    this.jobFamilyService.getList().subscribe({
      next: response => {
        this.jobFamily.dataList = response.map(x => {
          this.selectedItems.data.set(x.jobFamilyId, false)
          return new MyJobFamilyModel(x)
        })
        this.selectedItems.key = 'jobFamilyId'
        this.selectedItems.count = 0
        this.jobFamily.loading = false
        this.cdr.markForCheck();
      }, error: error => {
        this.jobFamily.loading = false
        console.error('Error fetching employee types:', error);
        this.cdr.markForCheck()
      }
    })
  }

  selectJobFamily(jobFamily?: any) {
    const JobFamily = this.jobFamily.dataList.find(e => e.jobFamilyId == jobFamily?.jobFamilyId)
    this.jobFamily.select = new MyJobFamilyModel(JobFamily)
  }

  addJobFamily() {
    Swal.fire({
      icon: 'question',
      title: 'แจ้งเตือน',
      text: 'ยืนยันการบันทึกข้อมูลหรือไม่',
      showCancelButton: true,
      confirmButtonText: 'ยืนยัน',
    }).then((result) => {
      if (result.isConfirmed) {
        this.jobFamily.loading = true
        this.jobFamilyService.post(new MyJobFamilyModel(this.jobFamily.select)).subscribe({
          next: response => {
            if (response.success) {
              this.showAlert(response.message, 'success')
              this.getJobFamilyList()
              this.closeDialog()
            } else {
              this.showAlert(response.message, 'error')
              this.jobFamily.loading = false
              this.cdr.markForCheck()
              this.closeDialog()
            }
          }, error: error => {
            this.showAlert(error.message, 'error')
            this.jobFamily.loading = false
            this.cdr.markForCheck()
            this.closeDialog()
          }
        })
      }
    })
  }

  deleteJobFamily() {
    if (this.numSelectItem() == 0) {
      this.showAlert('กรุณาเลือกข้อมูลที่จะลบ', 'error')
      return
    }
    Swal.fire({
      icon: 'question',
      title: 'แจ้งเตือน',
      text: 'ยืนยันการลบข้อมูลหรือไม่',
      showCancelButton: true,
      confirmButtonText: 'ลบข้อมูล',
    }).then((result) => {
      if (result.isConfirmed) {
        this.jobFamily.loading = true
        const selectedKeys = Array.from(this.selectedItems.data.keys());
        const body = this.jobFamily.dataList.filter(x => selectedKeys.includes(x.jobFamilyId) && this.selectedItems.data.get(x.jobFamilyId)).map(x => new MyJobFamilyModel(x))
        this.jobFamilyService.delete(body).subscribe({
          next: response => {
            if (response.success) {
              this.showAlert(response.message, 'success')
              this.getJobFamilyList()
            } else {
              this.showAlert(response.message, 'error')
              this.jobFamily.loading = false
              this.cdr.markForCheck()
            }
          }, error: error => {
            this.showAlert(error.message, 'error')
            this.jobFamily.loading = false
            this.cdr.markForCheck()
          }
        })
      }
    })
  }
  showAlert(text: string, type: 'success' | 'error') {
    Swal.fire({
      icon: type,
      title: 'แจ้งเตือน',
      text: text,
      showCancelButton: false,
      confirmButtonText: 'ยืนยัน',
    })
  }



  checkPrimary() {
    return this.jobFamily.dataList.find(x => x.jobFamilyId == this.jobFamily.select.jobFamilyId)
  }

  numSelectItem() {
    const selectedKeys = Array.from(this.selectedItems.data.keys());
    const num = this.jobFamily.dataList.filter(x => selectedKeys.includes(x.jobFamilyId) && this.selectedItems.data.get(x.jobFamilyId)).length
    return num
  }

  onSelectItemChange(arg: any) {
    this.selectedItems = arg
  }

  onImgSelected(event: any) {
    this.selectedImg = event.target.files.length > 0 ? event.target.files[0] : null;
    this.uploadImg()
  }
  uploadImg() {
    if (this.selectedImg) {
      this.imgLoading = true
      const formData = new FormData();
      formData.append('file', this.selectedImg);
      this.fileService.uploadImg(formData).subscribe({
        next: response => {
          if (response.success) {
            this.showAlert(response.message, 'success')
            this.jobFamily.select.jobGroupPicture = response.resultObject
          } else {
            this.showAlert(response.message, 'error')
            this.jobFamily.select.jobGroupPicture = ''
          }
          this.imgLoading = false
          this.cdr.markForCheck()
        }, error: error => {
          this.showAlert(error.message, 'error')
          this.jobFamily.select.jobGroupPicture = ''
          this.imgLoading = false
          this.cdr.markForCheck()
        }
      })
    }
  }
  getImg(text: string) {
    return this.fileService.getImg(text)
  }
  onImageError(event: Event) {
    const imgElement = event.target as HTMLImageElement;
    imgElement.src = './assets/img/users/defaultperson.jpg';
  }
}

