import { Injectable, OnDestroy } from '@angular/core';
import { Subject, BehaviorSubject, fromEvent } from 'rxjs';
import { takeUntil, debounceTime } from 'rxjs/operators';
import { Router } from '@angular/router';
import { MenuBodyModel, MyMenuBodyModel } from '../model/config-permission.model';
// Menu
export interface Menu {
  headTitle?: string;
  headTitle2?: string;
  path?: string;
  title?: string;
  icon?: string;
  type?: string;
  badgeValue?: string;
  badgeClass?: string;
  active?: boolean;
  selected?: boolean;
  bookmark?: boolean;
  children?: Menu[];
  children2?: Menu[];
  Menusub?: boolean;
  target?: boolean;
  show?: boolean
  id?: string
}

@Injectable({
  providedIn: 'root',
})
export class NavService implements OnDestroy {
  private unsubscriber: Subject<any> = new Subject();
  public screenWidth: BehaviorSubject<number> = new BehaviorSubject(
    window.innerWidth
  );

  // Search Box
  public search = false;

  // Language
  public language = false;

  // Mega Menu
  public megaMenu = false;
  public levelMenu = false;
  public megaMenuColapse: boolean = window.innerWidth < 1199 ? true : false;

  // Collapse Sidebar
  public collapseSidebar: boolean = window.innerWidth < 991 ? true : false;

  // For Horizontal Layout Mobile
  public horizontal: boolean = window.innerWidth < 991 ? false : true;

  // Full screen
  public fullScreen = false;
  active: any;

  constructor(private router: Router) {
    this.setScreenWidth(window.innerWidth);
    fromEvent(window, 'resize')
      .pipe(debounceTime(1000), takeUntil(this.unsubscriber))
      .subscribe((evt: any) => {
        this.setScreenWidth(evt.target.innerWidth);
        if (evt.target.innerWidth < 991) {
          this.collapseSidebar = true;
          this.megaMenu = false;
          this.levelMenu = false;
        }
        if (evt.target.innerWidth < 1199) {
          this.megaMenuColapse = true;
        }
      });
    if (window.innerWidth < 991) {
      // Detect Route change sidebar close
      this.router.events.subscribe((event) => {
        this.collapseSidebar = true;
        this.megaMenu = false;
        this.levelMenu = false;
      });
    }
  }

  ngOnDestroy() {
    this.unsubscriber.next;
    this.unsubscriber.complete();
  }

  private setScreenWidth(width: number): void {
    this.screenWidth.next(width);
  }

  private MENUITEMS: Menu[] = [

  ];

  getCustomerMenu() {
    return [
      {
        title: 'SelfEvaluate',
        type: 'link',
        selected: false,
        active: false,
        path: 'ess/self-evaluation',
        id: 'm1',
        show: true,
        icon: 'assets/img/icons-menu/com-self.png'
        // children: [
        //   { id: 'm11', path: 'ess/self-evaluation', title: 'ประเมินตนเอง', type: 'link', show: true },
        //   { id: 'm12', path: 'ess/supervisor-evaluation', title: 'ประเมินโดยหัวหน้า', type: 'link', show: true },
        // ],
      },
      {
        title: 'SupervisorEvaluate',
        type: 'link',
        selected: false,
        active: false,
        path: 'ess/supervisor-evaluation',
        id: 'm2',
        show: true,
        icon: 'assets/img/icons-menu/com-boss.png'
        // children: [
        //   { id: 'm11', path: 'ess/self-evaluation', title: 'ประเมินตนเอง', type: 'link', show: true },
        //   { id: 'm12', path: 'ess/supervisor-evaluation', title: 'ประเมินโดยหัวหน้า', type: 'link', show: true },
        // ],
      },
      {
        title: 'แก้ไข Individual KPI ตนเอง',
        type: 'link',
        selected: false,
        active: false,
        path: 'ess/self-setting-individual-kpi',
        id: 'm3',
        show: true,
        icon: ''
      },
      {
        title: 'แก้ไข Individual KPI โดยหัวหน้า',
        type: 'link',
        selected: false,
        active: false,
        path: 'ess/supervisor-setting-individual-kpi',
        id: 'm4',
        show: true,
        icon: ''
      },
      {
        title: 'ติดตามหลังการประเมิน',
        type: 'link',
        selected: false,
        active: false,
        path: 'ess/post-evaluation-tracking',
        id: 'm4',
        show: true,
        icon: ''
      },
    ];
  }

  getAdminMenu() {
    return [
      {
        title: 'menu.Dashboard',
        type: 'link',
        selected: true,
        active: true,
        path: '/dashboard/projects',
        id: 'm0',
        show: true,
        icon: 'assets/img/icons-menu/house_3781618.png'
      },
      // {
      //   title: 'ประเมินผล',
      //   type: 'sub',
      //   selected: false,
      //   active: false,
      //   path: '',
      //   id: 'm1',
      //   show: true,
      //   children: [
      //     { id: 'm11', path: '/self-evaluation', title: 'ประเมินตนเอง', type: 'link', show: true },
      //     { id: 'm12', path: '/supervisor-evaluation', title: 'ประเมินโดยหัวหน้า', type: 'link', show: true },
      //   ],
      // },
      {
        title: 'menu.Organization',
        type: 'sub',
        selected: false,
        active: false,
        path: '',
        id: 'm2',
        show: true,
        icon: 'assets/img/icons-menu/enterprise-data-management.png',
        children: [
          { id: 'm21', path: 'admin/company-registration', title: 'menu.Company', type: 'link', show: true },
          { id: 'm22', path: 'admin/job-description', title: 'menu.JobDescription', type: 'link', show: true },
          { id: 'm23', path: 'admin/employee-registration', title: 'menu.Employee', type: 'link', show: true },
          { id: 'm24', path: 'admin/day-type-registry', title: 'menu.LeaveType', type: 'link', show: true },
          { id: 'm25', path: 'admin/account-settings', title: 'menu.UserSetting', type: 'link', show: true },
          { id: 'm26', path: 'admin/role-permission-config', title: 'menu.AccessPermissions', type: 'link', show: true },
          { id: 'm27', path: 'admin/document-upload-manager', title: 'DocumentUploadManager', type: 'link', show: true },
          // { id: 'm27', path: 'admin/job-description-emp', title: 'ข้อมูลลักษณะงาน (JD)', type: 'link', show: true },
        ],
      },
      {
        title: 'menu.JobDescriptionJD',
        type: 'sub',
        selected: false,
        active: false,
        path: '',
        id: 'm3',
        show: true,
        icon: 'assets/img/icons-menu/job-detail-management.png',
        children: [
          { id: 'm31', path: 'admin/job-detail-management', title: 'menu.GeneralInformation', type: 'link', show: true },
          { id: 'm32', path: 'admin/command-structure', title: 'menu.OrganizationChart', type: 'link', show: true },
          { id: 'm33', path: 'admin/job-detail', title: 'menu.JobDetail', type: 'link', show: true },
          { id: 'm34', path: 'admin/job-qualifications', title: 'menu.JobSpecification', type: 'link', show: true },
          { id: 'm35', path: 'admin/job-competency', title: 'menu.JobCompetency', type: 'link', show: true },
          { id: 'm36', path: 'admin/job-position-indicators', title: 'menu.KeyPerformanceIndicators', type: 'link', show: true },
        ],
      },

      {
        title: 'menu.CompetencySystem',
        type: 'sub',
        selected: false,
        active: false,
        path: '',
        id: 'm4',
        show: true,
        icon: 'assets/img/icons-menu/performance-assessment.png',
        children: [
          { id: 'm41', path: 'admin/setting-competency', title: 'menu.Setting', type: 'link', show: true },
          { id: 'm42', path: 'admin/name-registration', title: 'menu.DataBankCompetency', type: 'link', show: true },
          { id: 'm43', path: 'admin/grade-registration', title: 'menu.Grade', type: 'link', show: true },
          { id: 'm44', path: 'admin/tool-register', title: 'menu.AssessmentTools', type: 'link', show: true },
          { id: 'm45', path: 'admin/course-registration', title: 'menu.CDR', type: 'link', show: true },
          { id: 'm46', path: 'admin/idp-development-plan', title: 'menu.IDP', type: 'link', show: true },
          { id: 'm465', path: 'admin/competency-evaluation-factors', title: 'menu.CompetencyFactors', type: 'link', show: true },
          { id: 'm47', path: 'admin/competency-management', title: 'menu.CompetencyManage', type: 'link', show: true },
          { id: 'm48', path: 'admin/evaluation-cycle-manager', title: 'menu.AssessmentPeriod', type: 'link', show: true },
        ],
      },
      {
        title: 'menu.PerformanceManagementSystem',
        type: 'sub',
        selected: false,
        active: false,
        path: '',
        id: 'm5',
        show: true,
        icon: 'assets/img/icons-menu/performance-management-assessment.png',
        children: [
          { id: 'm51', path: 'admin/setting-performance-evalution', title: 'menu.Setting', type: 'link', show: true },
          { id: 'm52', path: 'admin/name-registration-perfomance', title: 'menu.DataBankPms', type: 'link', show: true },
          { id: 'm53', path: 'admin/grade-registration-sub', title: 'menu.Grade', type: 'link', show: true },
          { id: 'm54', path: 'admin/time-attendance', title: 'menu.TimeAttendance', type: 'link', show: true },
          { id: 'm55', path: 'admin/evaluation-factors', title: 'menu.PmsFactors', type: 'link', show: true },
          { id: 'm56', path: 'admin/assessment-management', title: 'menu.PmsManage', type: 'link', show: true },
          { id: 'm57', path: 'admin/evaluation-cycle-performance', title: 'menu.EvaluationPeriod', type: 'link', show: true }
        ],
      },
      {
        title: 'Report',
        type: 'sub',
        selected: false,
        active: false,
        path: '',
        id: 'm6',
        show: true,
        icon: 'assets/img/icons-menu/Report.png',
        children: [
          { id: 'm61', path: 'admin/report-competency-summary', title: 'รายงานสรุปผลการประเมินสมรรถนะ', type: 'link', show: true },
          { id: 'm61', path: 'admin/report-com-1', title: 'รายงาน Competency 1', type: 'link', show: true },
          { id: 'm62', path: 'admin/report-com-2', title: 'รายงาน Competency 2', type: 'link', show: true },
          { id: 'm63', path: 'admin/report-com-3', title: 'รายงาน Competency 3', type: 'link', show: true },
          { id: 'm64', path: 'admin/report-pms-1', title: 'รายงาน PMS 1', type: 'link', show: true },
          { id: 'm65', path: 'admin/report-pms-2', title: 'รายงาน PMS 2', type: 'link', show: true },
          { id: 'm66', path: 'admin/report-pms-3', title: 'รายงาน PMS 3', type: 'link', show: true },
        ],
      },
      {
        title: 'ภาพรวมแดชบอร์ด',
        type: 'sub',
        selected: false,
        active: false,
        path: '',
        id: 'm7',
        show: true,
        icon: 'assets/img/icons-menu/Report.png',
        children:[
          { id: 'm71', path: 'admin/widget1', title: 'รายงานแดชบอร์ด', type: 'link', show: true },
        ]
      }
    ]
  }
  // Array
  items = new BehaviorSubject<Menu[]>(this.MENUITEMS);
  itemsBack = new BehaviorSubject<Menu[]>(this.getAdminMenu());

  private menuItemsSubject = new BehaviorSubject<Menu[]>(this.MENUITEMS);
  menuItems$ = this.menuItemsSubject.asObservable();


  toggleEvaluationMenu() {
    const menuItem = this.MENUITEMS.find(item => item.id === 'm1');
    if (menuItem) {
      menuItem.show = !menuItem.show;  // Toggle ซ่อน/แสดง
      menuItem.children?.forEach(child => child.show = menuItem.show);
      this.menuItemsSubject.next([...this.MENUITEMS]);

      const currentUrl = this.router.url;
      const evaluationPaths = menuItem.children?.map(child => child.path) || [];

      if (!menuItem.show && evaluationPaths.includes(currentUrl)) {
        this.router.navigate(['/company-registration']);
      }

      if (menuItem.show) {
        this.router.navigate(['/self-evaluation']);
      }
    }
  }
}
