export interface PrefixModel {
    edesc: string
    prefixId: string
    tdesc: string
}
export class MyPrefixModel implements PrefixModel {
    edesc: string
    prefixId: string
    tdesc: string
    constructor(data?: Partial<PrefixModel>) {
        this.edesc = data?.edesc || ''
        this.prefixId = data?.prefixId || ''
        this.tdesc = data?.tdesc || ''
    }
}

export interface CreateByModel {
    efname: string
    elname: string
    email: string
    employeeId: string
    engFullName: string
    fname: string
    lname: string
    picture: string
    prefix: PrefixModel
    sex: string
    thFullName: string
}
export class MyCreateByModel implements CreateByModel {
    efname: string
    elname: string
    email: string
    employeeId: string
    engFullName: string
    fname: string
    lname: string
    picture: string
    prefix: PrefixModel
    sex: string
    thFullName: string
    constructor(data?: Partial<CreateByModel>) {
        this.efname = data?.efname || ''
        this.elname = data?.elname || ''
        this.email = data?.email || ''
        this.employeeId = data?.employeeId || ''
        this.engFullName = data?.engFullName || ''
        this.fname = data?.fname || ''
        this.lname = data?.lname || ''
        this.picture = data?.picture || ''
        this.prefix = new MyPrefixModel(data?.prefix)
        this.sex = data?.sex || ''
        this.thFullName = data?.thFullName || ''
    }
}

export interface TemplateFileModel {
    createDate: string
    edesc: string
    fileName: string
    isDataGrid: string
    isPivot: string
    isShare: string
    itemId: string
    menuActive: string
    module: string
    page: string
    param: any | null
    portalId: string
    realFileName: string
    realFileNameOld: string
    tdesc: string
    templateId: string
    uponMenu: string
    fileData: string
    fileType: string
}
export class MyTemplateFileModel implements TemplateFileModel {
    createDate: string
    edesc: string
    fileName: string
    isDataGrid: string
    isPivot: string
    isShare: string
    itemId: string
    menuActive: string
    module: string
    page: string
    param: any | null
    portalId: string
    realFileName: string
    realFileNameOld: string
    tdesc: string
    templateId: string
    uponMenu: string
    fileData: string
    fileType: string
    constructor(data?: Partial<TemplateFileModel>) {
        this.createDate = data?.createDate || ''
        this.edesc = data?.edesc || ''
        this.fileName = data?.fileName || ''
        this.isDataGrid = data?.isDataGrid || '0'
        this.isPivot = data?.isPivot || '0'
        this.isShare = data?.isShare || '0'
        this.itemId = data?.itemId || ''
        this.menuActive = data?.menuActive || ''
        this.module = data?.module || ''
        this.page = data?.page || ''
        this.param = data?.param
        this.portalId = data?.portalId || ''
        this.realFileName = data?.realFileName || ''
        this.realFileNameOld = data?.realFileNameOld || ''
        this.tdesc = data?.tdesc || ''
        this.templateId = data?.templateId || ''
        this.uponMenu = data?.uponMenu || ''
        this.fileData = data?.fileData || ''
        this.fileType = data?.fileType || ''
    }
}

export interface TemplateModel {
    templateId: string
    tname: string
    ename: string
    tdesc: string
    edesc: string
    module: string
    templateFile: TemplateFileModel[]
}
export class MyTemplateModel implements TemplateModel {
    templateId: string
    tname: string
    ename: string
    tdesc: string
    edesc: string
    module: string
    templateFile: TemplateFileModel[]
    constructor(data?: Partial<TemplateModel>) {
        this.templateId = data?.templateId || ''
        this.tname = data?.tname || ''
        this.ename = data?.ename || ''
        this.tdesc = data?.tdesc || ''
        this.edesc = data?.edesc || ''
        this.module = data?.module || ''
        this.templateFile = data?.templateFile?.map(x => new MyTemplateFileModel(x)) || []
    }
}