import { DevelopmentPlanModel, MyDevelopmentPlanModel } from "./development-plan.model";

export interface IdpDevelopmentModel {
  evaluationId: string;
  companyId: string;
  score: number;
  developmentPlan: DevelopmentPlanModel[];
}

export class MyIdpDevelopmentModel implements IdpDevelopmentModel {
  evaluationId: string;
  companyId: string;
  score: number;
  developmentPlan: DevelopmentPlanModel[];

  constructor(data?: Partial<IdpDevelopmentModel>) {
    this.evaluationId = data?.evaluationId || '';
    this.companyId = data?.companyId || '';
    this.score = data?.score ?? 0;
    this.developmentPlan = data?.developmentPlan?.map(x => new MyDevelopmentPlanModel(x)) || [];
  }
}
