import { CompetencyCourseModel, MyCompetencyCourseModel } from "./competency-course.model"
import { CompetencyIndicatorsCourses2ListModel, MyCompetencyIndicatorsCourses2ListModel } from "./competency-indicators-courses2-list.model"

export interface CompetencyIndicatorsCourses1ListModel {
    lineNo: number
    companyId: string
    competencyCourseId: string
    competencyCourse: CompetencyCourseModel[]
    competencyIndicatorsCourses2List: CompetencyIndicatorsCourses2ListModel[]
}
export class MyCompetencyIndicatorsCourses1ListModel implements CompetencyIndicatorsCourses1ListModel {
    lineNo: number
    companyId: string
    competencyCourseId: string
    competencyCourse: CompetencyCourseModel[]
    competencyIndicatorsCourses2List: CompetencyIndicatorsCourses2ListModel[]
    constructor(data?: Partial<CompetencyIndicatorsCourses1ListModel>) {
        this.lineNo = data?.lineNo ?? 0
        this.companyId = data?.companyId || ""
        this.competencyCourseId = data?.competencyCourseId || ""
        this.competencyCourse = data?.competencyCourse?.map(x => new MyCompetencyCourseModel(x)) || []
        this.competencyIndicatorsCourses2List = data?.competencyIndicatorsCourses2List?.map(x => new MyCompetencyIndicatorsCourses2ListModel(x)) || []
    }
}

